/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support.impl;

import com.cloudbees.jenkins.support.api.Component;
import com.cloudbees.jenkins.support.api.Container;
import com.cloudbees.jenkins.support.api.PrefilteredPrintedContent;
import com.cloudbees.jenkins.support.filter.ContentFilter;
import com.cloudbees.jenkins.support.util.Markdown;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Functions;
import hudson.model.Cause;
import hudson.model.Item;
import hudson.model.Queue;
import hudson.model.queue.QueueTaskDispatcher;
import hudson.security.Permission;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Set;
import jenkins.model.Jenkins;

@Extension
public class BuildQueue
extends Component {
    @Override
    @NonNull
    public Set<Permission> getRequiredPermissions() {
        return Collections.singleton(Jenkins.ADMINISTER);
    }

    @Override
    @NonNull
    public String getDisplayName() {
        return "Build queue";
    }

    @Override
    public void addContents(@NonNull Container container) {
        container.add(new PrefilteredPrintedContent("buildqueue.md"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void printTo(PrintWriter out, ContentFilter filter) {
                try {
                    Queue.Item[] items = Jenkins.get().getQueue().getItems();
                    out.println("Current build queue has " + items.length + " item(s).");
                    out.println("---------------");
                    for (Queue.Item item : items) {
                        if (item instanceof Item) {
                            out.println(" * Name of item: " + ContentFilter.filter(filter, ((Item)item).getFullName()));
                        } else {
                            out.println(" * Name of item: " + ContentFilter.filter(filter, Functions.escape((String)item.task.getFullDisplayName())));
                        }
                        out.println("    - In queue for: " + item.getInQueueForString());
                        out.println("    - Is blocked: " + item.isBlocked());
                        out.println("    - Why in queue: " + Markdown.escapeUnderscore(ContentFilter.filter(filter, item.getWhy())));
                        for (Cause cause : item.getCauses()) {
                            out.println("    - Current queue trigger cause: " + Markdown.escapeUnderscore(ContentFilter.filter(filter, cause.getShortDescription())));
                        }
                        for (QueueTaskDispatcher taskDispatcher : QueueTaskDispatcher.all()) {
                            out.println("  * Task Dispatcher: " + String.valueOf(taskDispatcher));
                            out.println("    - Can run: " + String.valueOf(taskDispatcher.canRun(item)));
                        }
                        out.println("----");
                        out.println();
                    }
                    out.println("Is quieting down: " + Jenkins.get().isQuietingDown());
                }
                finally {
                    out.flush();
                }
            }
        });
    }

    @Override
    @NonNull
    public Component.ComponentCategory getCategory() {
        return Component.ComponentCategory.BUILDS;
    }
}

