/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support.filter;

import com.cloudbees.jenkins.support.filter.ContentFilter;
import com.cloudbees.jenkins.support.filter.ContentMapping;
import com.cloudbees.jenkins.support.filter.ContentMappings;
import com.cloudbees.jenkins.support.filter.NameProvider;
import com.cloudbees.jenkins.support.filter.WordsTrie;
import com.cloudbees.jenkins.support.util.WordReplacer;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.StreamSupport;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Extension
@Restricted(value={NoExternalUse.class})
public class SensitiveContentFilter
implements ContentFilter {
    private static final Logger LOGGER = Logger.getLogger(SensitiveContentFilter.class.getName());
    private final AtomicReference<Pattern> mappingsPattern = new AtomicReference();
    private final AtomicReference<Map<String, String>> replacementsMap = new AtomicReference();

    public static SensitiveContentFilter get() {
        return (SensitiveContentFilter)ExtensionList.lookupSingleton(SensitiveContentFilter.class);
    }

    @Override
    @NonNull
    public String filter(@NonNull String input) {
        return WordReplacer.replaceWords(input, this.mappingsPattern.get(), this.replacementsMap.get());
    }

    @Override
    public synchronized void reload() {
        long startTime = System.currentTimeMillis();
        HashMap replacementsMap = new HashMap();
        WordsTrie trie = new WordsTrie();
        ContentMappings mappings = ContentMappings.get();
        Set<String> stopWords = mappings.getStopWords();
        StreamSupport.stream(mappings.spliterator(), false).filter((? super T mapping) -> !mapping.getReplacement().startsWith("ip_")).forEach(contentMapping -> {
            String lowerCaseOriginal = contentMapping.getOriginal().toLowerCase(Locale.ENGLISH);
            if (!stopWords.contains(lowerCaseOriginal)) {
                replacementsMap.put(lowerCaseOriginal, contentMapping.getReplacement().replaceAll("\\\\", "\\\\\\\\").replaceAll("\\$", "\\\\\\$"));
                trie.add(lowerCaseOriginal);
            }
        });
        NameProvider.all().forEach(provider -> provider.names().filter((? super T s) -> !s.isBlank()).forEach(name -> {
            String lowerCaseOriginal = name.toLowerCase(Locale.ENGLISH);
            if (!stopWords.contains(lowerCaseOriginal)) {
                ContentMapping mapping = mappings.getMappingOrCreate((String)name, original -> ContentMapping.of(original, provider.generateFake()));
                replacementsMap.putIfAbsent(lowerCaseOriginal, mapping.getReplacement().replaceAll("\\\\", "\\\\\\\\").replaceAll("\\$", "\\\\\\$"));
                trie.add(lowerCaseOriginal);
            }
        }));
        this.mappingsPattern.set(Pattern.compile("(?<!\\w)" + trie.getRegex() + "(?!\\w)", 66));
        this.replacementsMap.set(replacementsMap);
        LOGGER.log(Level.FINE, "Took " + (System.currentTimeMillis() - startTime) + "ms to reload");
    }
}

