/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support.filter;

import com.cloudbees.jenkins.support.filter.DataFaker;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.model.Label;
import hudson.model.User;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class NameProvider
implements ExtensionPoint {
    private final Supplier<Stream<String>> names;
    private final Supplier<String> fakes;
    @Extension
    public static final NameProvider ITEMS = new NameProvider(() -> NameProvider.stream(Jenkins.get().allItems()).flatMap(item -> Stream.of(item.getName(), item.getDisplayName())), DataFaker.get().apply(name -> "item_" + name));
    @Extension
    public static final NameProvider VIEWS = new NameProvider(() -> NameProvider.stream(Jenkins.get().getViews()).flatMap(view -> Stream.of(view.getViewName(), view.getDisplayName())), DataFaker.get().apply(name -> "view_" + name));
    @Extension
    public static final NameProvider NODES = new NameProvider(() -> NameProvider.stream(Jenkins.get().getNodes()).flatMap(node -> Stream.of(node.getNodeName(), node.getDisplayName())), DataFaker.get().apply(name -> "node_" + name));
    @Extension
    public static final NameProvider COMPUTERS = new NameProvider(() -> NameProvider.stream(Jenkins.get().getComputers()).flatMap(computer -> Stream.of(computer.getName(), computer.getDisplayName())), DataFaker.get().apply(name -> "computer_" + name));
    @Extension
    public static final NameProvider USERS = new NameProvider(() -> NameProvider.stream(User.getAll()).flatMap(user -> Stream.of(user.getId(), user.getFullName(), user.getDisplayName())), DataFaker.get().apply(name -> "user_" + name));
    @Extension(ordinal=-100.0)
    public static final NameProvider LABELS = new NameProvider(() -> NameProvider.stream(Jenkins.get().getLabels()).map(Label::getDisplayName), DataFaker.get().apply(name -> "label_" + name));

    private NameProvider(@NonNull Supplier<Stream<String>> names, @NonNull Supplier<String> fakes) {
        this.names = names;
        this.fakes = fakes;
    }

    @NonNull
    public Stream<String> names() {
        return this.names.get();
    }

    @NonNull
    public String generateFake() {
        return this.fakes.get();
    }

    @NonNull
    public static ExtensionList<NameProvider> all() {
        return ExtensionList.lookup(NameProvider.class);
    }

    private static <T> Stream<T> stream(Iterable<T> iterable) {
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    private static <T> Stream<T> stream(T[] array) {
        return StreamSupport.stream(Arrays.spliterator(array), false);
    }

    private static <T> Stream<T> stream(Collection<T> collection) {
        return collection.stream();
    }
}

