/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support.filter;

import com.cloudbees.jenkins.support.filter.ContentFilter;
import com.cloudbees.jenkins.support.filter.FilteredConstants;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.CharBuffer;
import java.util.regex.Matcher;
import net.jcip.annotations.GuardedBy;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class FilteredWriter
extends FilterWriter {
    private final ContentFilter contentFilter;
    @GuardedBy(value="this")
    private CharBuffer buf;

    FilteredWriter(@NonNull Writer writer, @NonNull ContentFilter contentFilter) {
        super(writer);
        this.contentFilter = contentFilter;
    }

    private void ensureOpen() {
        if (this.out == null) {
            throw new IllegalStateException("FilteredWriter is closed");
        }
        if (this.buf == null) {
            this.buf = CharBuffer.allocate(1024);
        }
    }

    @Override
    public synchronized void write(int c) throws IOException {
        this.write(Character.toChars(c));
    }

    @Override
    public synchronized void write(@NonNull char[] cbuf, int off, int len) throws IOException {
        this.ensureOpen();
        while (len > 0) {
            int toCopy;
            if (!this.buf.hasRemaining()) {
                this.filterFlushLines();
            }
            if (!this.buf.hasRemaining()) {
                this.buf = CharBuffer.allocate(this.buf.capacity() * 2).put(this.buf);
            }
            if ((toCopy = Math.min(this.buf.remaining(), len)) == 0) {
                throw new IllegalStateException();
            }
            this.buf.put(cbuf, off, toCopy);
            this.filterFlushLines();
            len -= toCopy;
            off += toCopy;
        }
        this.filterFlushLines();
    }

    @Override
    public synchronized void write(@NonNull String str, int off, int len) throws IOException {
        this.ensureOpen();
        while (len > 0) {
            int toCopy;
            if (!this.buf.hasRemaining()) {
                this.filterFlushLines();
            }
            if (!this.buf.hasRemaining()) {
                this.buf = CharBuffer.allocate(this.buf.capacity() * 2).put(this.buf);
            }
            if ((toCopy = Math.min(this.buf.remaining(), len)) == 0) {
                throw new IllegalStateException();
            }
            this.buf.put(str, off, off + toCopy);
            this.filterFlushLines();
            len -= toCopy;
            off += toCopy;
        }
        this.filterFlushLines();
    }

    @Override
    public synchronized void flush() throws IOException {
        this.ensureOpen();
        if (this.buf.position() > 0) {
            this.buf.flip();
            String original = this.buf.toString();
            String filtered = ContentFilter.filter(this.contentFilter, original);
            this.out.write(filtered);
            this.buf.clear();
        }
        this.out.flush();
    }

    @Override
    public synchronized void close() throws IOException {
        this.flush();
        this.out.close();
        this.out = null;
        this.buf = null;
    }

    private void filterFlushLines() throws IOException {
        this.ensureOpen();
        if (this.buf.position() > 0) {
            this.buf.flip();
            Matcher matcher = FilteredConstants.EOL.matcher(this.buf);
            int start = 0;
            while (matcher.find()) {
                int end = matcher.end();
                String line = this.buf.subSequence(start, end).toString();
                String filtered = ContentFilter.filter(this.contentFilter, line);
                this.out.write(filtered);
                start = end;
            }
            this.buf.position(start);
            this.buf.compact();
        }
    }
}

