/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support.filter;

import com.cloudbees.jenkins.support.filter.ContentFilter;
import com.cloudbees.jenkins.support.util.WordReplacer;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Functions;
import java.util.HashSet;
import java.util.Objects;
import net.jcip.annotations.Immutable;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Immutable
@Restricted(value={NoExternalUse.class})
public class ContentMapping
implements ContentFilter {
    private static final String ALT_SEPARATOR = " \u00bb ";
    private final String original;
    private final String replacement;
    private final int hashCode;
    private final String[] originals;
    private final String[] replacements;

    private ContentMapping(@NonNull String original, @NonNull String replacement) {
        this.original = original;
        this.replacement = replacement;
        String slashChangedInOriginal = original.replace("/", ALT_SEPARATOR);
        HashSet<String> originalsSet = new HashSet<String>(4);
        originalsSet.add(original);
        originalsSet.add(Functions.escape((String)original));
        originalsSet.add(slashChangedInOriginal);
        originalsSet.add(Functions.escape((String)slashChangedInOriginal));
        this.originals = originalsSet.toArray(new String[0]);
        this.replacements = new String[this.originals.length];
        for (int i = 0; i < this.replacements.length; ++i) {
            this.replacements[i] = replacement;
        }
        this.hashCode = original.hashCode();
    }

    public static ContentMapping of(@NonNull String original, @NonNull String replacement) {
        return new ContentMapping(original, replacement);
    }

    @NonNull
    public String getOriginal() {
        return this.original;
    }

    @NonNull
    public String getReplacement() {
        return this.replacement;
    }

    @Override
    @NonNull
    public String filter(@NonNull String input) {
        return WordReplacer.replaceWordsIgnoreCase(input, this.originals, this.replacements);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContentMapping that = (ContentMapping)o;
        return Objects.equals(this.original, that.original);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private Object writeReplace() {
        SerializationProxy proxy = new SerializationProxy();
        proxy.original = this.original;
        proxy.replacement = this.replacement;
        return proxy;
    }

    private static class SerializationProxy {
        private String original;
        private String replacement;

        private SerializationProxy() {
        }

        private Object readResolve() {
            return ContentMapping.of(this.original, this.replacement);
        }
    }
}

