/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support.configfiles;

import com.cloudbees.jenkins.support.api.Component;
import com.cloudbees.jenkins.support.api.Container;
import com.cloudbees.jenkins.support.configfiles.XmlRedactedSecretFileContent;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.security.Permission;
import java.io.File;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;

@Extension
public class ConfigFileComponent
extends Component {
    private static final Logger LOGGER = Logger.getLogger(ConfigFileComponent.class.getName());

    @Override
    @NonNull
    public Set<Permission> getRequiredPermissions() {
        return Collections.singleton(Jenkins.ADMINISTER);
    }

    @Override
    @NonNull
    public String getDisplayName() {
        return "Jenkins Global Configuration File (Encrypted secrets are redacted)";
    }

    @Override
    public void addContents(@NonNull Container container) {
        Jenkins jenkins = Jenkins.get();
        File configFile = new File(jenkins.getRootDir(), "config.xml");
        if (configFile.exists()) {
            container.add(new XmlRedactedSecretFileContent("jenkins-root-configuration-files/{0}", new String[]{configFile.getName()}, configFile));
        } else {
            LOGGER.log(Level.WARNING, "Jenkins global config file does not exist.");
        }
    }

    @Override
    public boolean isSelectedByDefault() {
        return false;
    }

    @Override
    @NonNull
    public Component.ComponentCategory getCategory() {
        return Component.ComponentCategory.CONTROLLER;
    }
}

