/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support.config;

import com.cloudbees.jenkins.support.config.Messages;
import com.cloudbees.jenkins.support.config.SupportPluginConfigurationCategory;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.BulkChange;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.Functions;
import hudson.XmlFile;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.ManagementLink;
import hudson.model.Saveable;
import hudson.model.listeners.SaveableListener;
import hudson.security.Permission;
import hudson.util.FormApply;
import jakarta.servlet.ServletException;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.verb.POST;

@Extension
@Restricted(value={NoExternalUse.class})
@Symbol(value={"supportCore"})
public class SupportPluginManagement
extends ManagementLink
implements Describable<SupportPluginManagement>,
Saveable {
    private static final Logger LOG = Logger.getLogger(SupportPluginManagement.class.getName());
    public static final Predicate<Descriptor> CATEGORY_FILTER = descriptor -> descriptor.getCategory() instanceof SupportPluginConfigurationCategory;

    @NonNull
    public static SupportPluginManagement get() {
        return (SupportPluginManagement)((Object)ExtensionList.lookupSingleton(SupportPluginManagement.class));
    }

    public SupportPluginManagement() {
        this.load();
    }

    @CheckForNull
    public String getIconFileName() {
        return "symbol-support plugin-support-core";
    }

    public String getDisplayName() {
        return Messages.SupportPluginManagement_displayName();
    }

    public String getUrlName() {
        return "supportCore";
    }

    public String getDescription() {
        return Messages.SupportPluginManagement_description();
    }

    public Permission getRequiredPermission() {
        return Jenkins.ADMINISTER;
    }

    @NonNull
    public String getCategoryName() {
        return "CONFIGURATION";
    }

    private XmlFile getConfigFile() {
        return new XmlFile(new File(Jenkins.get().getRootDir(), ((Object)((Object)this)).getClass().getName() + ".xml"));
    }

    public synchronized void load() {
        XmlFile file = this.getConfigFile();
        if (!file.exists()) {
            return;
        }
        try {
            file.unmarshal((Object)this);
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "Failed to load " + String.valueOf(file), e);
        }
    }

    public void save() throws IOException {
        if (BulkChange.contains((Saveable)this)) {
            return;
        }
        try {
            this.getConfigFile().write((Object)this);
            SaveableListener.fireOnChange((Saveable)this, (XmlFile)this.getConfigFile());
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "Failed to save " + String.valueOf(this.getConfigFile()), e);
        }
    }

    @POST
    public synchronized void doConfigure(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException, Descriptor.FormException {
        this.configure(req, req.getSubmittedForm());
        FormApply.success((String)(req.getContextPath() + "/manage")).generateResponse(req, rsp, null);
    }

    public boolean configure(StaplerRequest2 req, JSONObject json) throws Descriptor.FormException {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        boolean result = true;
        for (Descriptor d : this.getDescriptors()) {
            result &= this.configureDescriptor(req, json, d);
        }
        return result;
    }

    private boolean configureDescriptor(StaplerRequest2 req, JSONObject json, Descriptor<?> d) throws Descriptor.FormException {
        String name = d.getJsonSafeClassName();
        JSONObject js = json.has(name) ? json.getJSONObject(name) : new JSONObject();
        json.putAll((Map)js);
        return d.configure(req, js);
    }

    @NonNull
    public Collection<Descriptor> getDescriptors() {
        return Functions.getSortedDescriptorsForGlobalConfigByDescriptor(CATEGORY_FILTER);
    }

    public Descriptor<SupportPluginManagement> getDescriptor() {
        return Jenkins.get().getDescriptorOrDie(((Object)((Object)this)).getClass());
    }

    @Extension
    @Symbol(value={"supportCore"})
    public static final class DescriptorImpl
    extends Descriptor<SupportPluginManagement> {
        public String getDisplayName() {
            return Messages.SupportPluginManagement_displayName();
        }
    }
}

