/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support.api;

import com.cloudbees.jenkins.support.api.Content;
import com.cloudbees.jenkins.support.api.TruncationException;
import java.io.BufferedWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;

public abstract class TruncatedContent
extends Content {
    private int maxSize;

    public TruncatedContent(String name) {
        this(name, 2000000);
    }

    public TruncatedContent(String name, int maxSize) {
        super(name);
        this.maxSize = maxSize;
    }

    public TruncatedContent(String name, String ... filterableParameters) {
        this(name, filterableParameters, 2000000);
    }

    public TruncatedContent(String name, String[] filterableParameters, int maxSize) {
        super(name, filterableParameters);
        this.maxSize = maxSize;
    }

    @Override
    public void writeTo(OutputStream os) throws IOException {
        PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new TruncatedOutputStream(os, this.maxSize), "UTF-8")));
        try {
            this.printTo(out);
        }
        finally {
            out.flush();
        }
    }

    protected abstract void printTo(PrintWriter var1) throws IOException;

    public static class TruncatedOutputStream
    extends FilterOutputStream {
        private final int max;
        private int currentSize;

        public TruncatedOutputStream(OutputStream os, int max) {
            super(os);
            this.max = max;
            this.currentSize = 0;
        }

        @Override
        public void write(int b) throws IOException {
            if (this.max >= this.currentSize) {
                this.out.write(b);
                ++this.currentSize;
            } else {
                throw new TruncationException("Max file size reached: " + this.max);
            }
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            int writeSize = Math.min(this.max - this.currentSize, len);
            if (writeSize > 0) {
                this.out.write(b, off, writeSize);
                this.currentSize += writeSize;
            } else {
                throw new TruncationException("Max file size reached: " + this.max);
            }
        }
    }
}

