/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support.api;

import com.cloudbees.jenkins.support.api.FileContent;
import com.cloudbees.jenkins.support.filter.ContentFilter;
import hudson.Util;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TemporaryFileContent
extends FileContent {
    private File f;
    private static final Logger LOGGER = Logger.getLogger(TemporaryFileContent.class.getName());

    public TemporaryFileContent(String name, File file) {
        super(name, file);
        this.f = file;
    }

    public TemporaryFileContent(String name, String[] filterableParameters, File file) {
        super(name, filterableParameters, file);
        this.f = file;
    }

    @Override
    public void writeTo(OutputStream os) throws IOException {
        try {
            super.writeTo(os);
        }
        finally {
            this.delete();
        }
    }

    @Override
    public void writeTo(OutputStream os, ContentFilter filter) throws IOException {
        try {
            super.writeTo(os, filter);
        }
        finally {
            this.delete();
        }
    }

    private void delete() {
        try {
            Util.deleteFile((File)this.f);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to delete tmp file " + this.f.getAbsolutePath(), e);
        }
    }
}

