/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support.api;

import com.cloudbees.jenkins.support.api.Content;
import com.cloudbees.jenkins.support.filter.PasswordRedactor;
import hudson.FilePath;
import hudson.Functions;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.nio.file.NoSuchFileException;
import org.apache.commons.io.IOUtils;

public class FilePathContent
extends Content {
    private final FilePath file;

    private static boolean isFileNotFound(Throwable e) {
        return e instanceof FileNotFoundException || e instanceof NoSuchFileException;
    }

    public FilePathContent(String name, FilePath file) {
        super(name);
        this.file = file;
    }

    public FilePathContent(String name, String[] filterableParameters, FilePath file) {
        super(name, filterableParameters);
        this.file = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTo(OutputStream os) throws IOException {
        try {
            if (PasswordRedactor.FILES_WITH_SECRETS.contains(this.file.getName())) {
                this.copyRedacted(os);
            } else {
                this.file.copyTo(os);
            }
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        catch (IOException e) {
            if (FilePathContent.isFileNotFound(e) || FilePathContent.isFileNotFound(e.getCause())) {
                OutputStreamWriter osw = new OutputStreamWriter(os, "utf-8");
                try {
                    PrintWriter pw = new PrintWriter((Writer)osw, true);
                    try {
                        pw.println("--- WARNING: Could not attach " + this.file.getRemote() + " as it cannot currently be found ---");
                        pw.println();
                        Functions.printStackTrace((Throwable)e, (PrintWriter)pw);
                    }
                    finally {
                        pw.flush();
                    }
                }
                finally {
                    osw.flush();
                }
            }
            throw e;
        }
    }

    @Override
    public long getTime() throws IOException {
        try {
            return this.file.lastModified();
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    private void copyRedacted(OutputStream os) throws IOException, InterruptedException {
        CharsetDecoder charsetDecoder = StandardCharsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).replaceWith("\ufffd");
        try (BufferedReader br = new BufferedReader(new InputStreamReader(this.file.read(), charsetDecoder));){
            String line;
            while ((line = br.readLine()) != null) {
                IOUtils.write((String)PasswordRedactor.get().redact(line), (OutputStream)os, (Charset)charsetDecoder.charset());
            }
        }
    }
}

