/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support.api;

import com.cloudbees.jenkins.support.Messages;
import com.cloudbees.jenkins.support.api.Container;
import com.cloudbees.jenkins.support.api.SupportContext;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.ExtensionPoint;
import hudson.model.AbstractModelObject;
import hudson.security.ACL;
import hudson.security.Permission;
import java.util.Collections;
import java.util.Set;
import jenkins.model.Jenkins;
import org.jvnet.localizer.Localizable;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import org.springframework.security.core.Authentication;

@ExportedBean
public abstract class Component
implements ExtensionPoint {
    @NonNull
    public abstract Set<Permission> getRequiredPermissions();

    private Set<Permission> _getRequiredPermissions() {
        try {
            return this.getRequiredPermissions();
        }
        catch (AbstractMethodError x) {
            return Collections.emptySet();
        }
    }

    public String getDisplayPermissions() {
        StringBuilder buf = new StringBuilder();
        boolean first = true;
        for (Permission p : this._getRequiredPermissions()) {
            if (first) {
                first = false;
            } else {
                buf.append(", ");
            }
            buf.append(p.group.title.toString());
            buf.append('/');
            buf.append(p.name);
        }
        return buf.toString();
    }

    @Exported
    public boolean isEnabled() {
        ACL acl = Jenkins.get().getAuthorizationStrategy().getRootACL();
        Authentication authentication = Jenkins.getAuthentication2();
        for (Permission p : this._getRequiredPermissions()) {
            if (acl.hasPermission2(authentication, p)) continue;
            return false;
        }
        return true;
    }

    @Exported
    public boolean isSelectedByDefault() {
        return true;
    }

    public boolean canBeGeneratedAsync() {
        return true;
    }

    public <C extends AbstractModelObject> boolean isApplicable(Class<C> clazz) {
        return Jenkins.class.isAssignableFrom(clazz);
    }

    @Exported
    @NonNull
    public abstract String getDisplayName();

    public abstract void addContents(@NonNull Container var1);

    @Exported
    @NonNull
    public String getId() {
        return this.getClass().getSimpleName();
    }

    @Deprecated
    public void start(@NonNull SupportContext context) {
    }

    @Exported
    @NonNull
    public ComponentCategory getCategory() {
        return ComponentCategory.UNCATEGORIZED;
    }

    public boolean supersedes(Component component) {
        return false;
    }

    public static enum ComponentCategory {
        AGENT(Messages._SupportPlugin_Category_Agent()),
        BUILDS(Messages._SupportPlugin_Category_Builds()),
        CONTROLLER(Messages._SupportPlugin_Category_Controller()),
        LOGS(Messages._SupportPlugin_Category_Logs()),
        MISC(Messages._SupportPlugin_Category_Misc()),
        PLATFORM(Messages._SupportPlugin_Category_Platform()),
        UNCATEGORIZED(Messages._SupportPlugin_Category_Uncategorized());

        private final Localizable label;

        private ComponentCategory(Localizable label) {
            this.label = label;
        }

        @NonNull
        public String getLabel() {
            return this.label.toString();
        }
    }
}

