/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support.api;

import com.cloudbees.jenkins.support.AsyncResultCache;
import hudson.Functions;
import hudson.model.Node;
import hudson.remoting.Callable;
import hudson.remoting.VirtualChannel;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.security.MasterToSlaveCallable;
import org.apache.commons.io.IOUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
class BaseCommandOutputContent {
    private static final Logger LOGGER = Logger.getLogger(BaseCommandOutputContent.class.getName());

    BaseCommandOutputContent() {
    }

    private static String getNodeName(Node node) {
        return node instanceof Jenkins ? "master" : node.getNodeName();
    }

    static String runOnNode(Node node, String ... command) {
        String content = "Exception occurred while retrieving command content";
        VirtualChannel chan = node.getChannel();
        if (chan == null) {
            content = "No connection to node";
        } else {
            try {
                content = (String)chan.call((Callable)new CommandLauncher(command));
            }
            catch (IOException | InterruptedException e) {
                LogRecord lr = new LogRecord(Level.FINE, "Could not retrieve command content from {0}");
                lr.setParameters(new Object[]{BaseCommandOutputContent.getNodeName(node)});
                lr.setThrown(e);
                LOGGER.log(lr);
            }
        }
        return content;
    }

    static String runOnNodeAndCache(WeakHashMap<Node, String> cache, Node node, String ... command) {
        String content = "Exception occurred while retrieving command content";
        try {
            content = AsyncResultCache.get(node, cache, new CommandLauncher(command), "sysctl info", "N/A: Either no connection to node or no cached result");
        }
        catch (IOException e) {
            LogRecord lr = new LogRecord(Level.FINE, "Could not retrieve sysctl content from {0}");
            lr.setParameters(new Object[]{BaseCommandOutputContent.getNodeName(node)});
            lr.setThrown(e);
            LOGGER.log(lr);
        }
        return content;
    }

    private static class CommandLauncher
    extends MasterToSlaveCallable<String, RuntimeException> {
        final String[] command;

        private CommandLauncher(String ... command) {
            this.command = command;
        }

        public String call() {
            StringWriter bos = new StringWriter();
            PrintWriter pw = new PrintWriter(bos);
            try {
                Process proc = new ProcessBuilder(new String[0]).command(this.command).redirectErrorStream(true).start();
                IOUtils.copy((InputStream)proc.getInputStream(), (Writer)pw, (Charset)Charset.defaultCharset());
            }
            catch (Exception e) {
                Functions.printStackTrace((Throwable)e, (PrintWriter)pw);
            }
            pw.flush();
            return bos.toString();
        }
    }
}

