/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support;

import com.cloudbees.jenkins.support.util.StreamUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.jenkins.lib.support_log_formatter.SupportLogFormatter;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import net.jcip.annotations.GuardedBy;

public class SupportLogHandler
extends Handler {
    private final Lock outputLock = new ReentrantLock();
    private final int fileSize;
    @GuardedBy(value="outputLock")
    private final LogRecord[] records;
    @GuardedBy(value="outputLock")
    private int position;
    @GuardedBy(value="outputLock")
    private int count;
    @GuardedBy(value="outputLock")
    private int fileCount;
    @GuardedBy(value="outputLock")
    private Writer writer;
    @GuardedBy(value="outputLock")
    private File logDirectry;
    private String logFilePrefix;
    private final SimpleDateFormat dateFormat;
    private final int maxFiles;

    public SupportLogHandler(int size, int fileSize, int maxFiles) {
        this.maxFiles = maxFiles;
        this.records = new LogRecord[size];
        this.position = 0;
        this.count = 0;
        this.fileCount = 0;
        this.fileSize = fileSize;
        this.setFormatter((Formatter)new SupportLogFormatter());
        this.dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss");
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public void setDirectory(File directory, String namePrefix) {
        this.outputLock.lock();
        try {
            this.logDirectry = directory;
            this.logFilePrefix = namePrefix;
            this.rollOver();
        }
        finally {
            this.outputLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(LogRecord record) {
        this.outputLock.lock();
        try {
            int maxCount = this.records.length;
            this.records[(this.position + this.count) % maxCount] = record;
            if (this.count == maxCount) {
                this.position = (this.position + 1) % maxCount;
            } else {
                ++this.count;
            }
            if (this.isLoggable(record) && this.writer != null) {
                if (this.fileCount > this.fileSize) {
                    this.rollOver();
                }
                if (this.writer != null) {
                    try {
                        ++this.fileCount;
                        this.writer.write(this.getFormatter().format(record));
                        this.flush();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
        finally {
            this.outputLock.unlock();
        }
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"}, justification="Best effort")
    private void rollOver() {
        this.outputLock.lock();
        try {
            this.setFile(null);
            if (this.logDirectry != null) {
                this.setFile(new File(this.logDirectry, this.logFilePrefix + "_" + this.dateFormat.format(new Date()) + ".log"));
                File[] files = this.logDirectry.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.startsWith(SupportLogHandler.this.logFilePrefix) && name.endsWith(".log");
                    }
                });
                if (files != null && files.length > this.maxFiles) {
                    Arrays.sort(files, (o1, o2) -> {
                        long lm1 = o1.lastModified();
                        long lm2 = o2.lastModified();
                        return Long.compare(lm1, lm2);
                    });
                    for (int i = 0; i < files.length - this.maxFiles; ++i) {
                        files[i].delete();
                    }
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        finally {
            this.outputLock.unlock();
        }
    }

    @Override
    public void flush() {
        this.outputLock.lock();
        try {
            if (this.writer != null) {
                try {
                    this.writer.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        finally {
            this.outputLock.unlock();
        }
    }

    @Override
    public void close() throws SecurityException {
        this.outputLock.lock();
        try {
            if (this.writer != null) {
                StreamUtils.closeQuietly(this.writer);
                this.writer = null;
            }
        }
        finally {
            this.outputLock.unlock();
        }
    }

    public List<LogRecord> getRecent() {
        this.outputLock.lock();
        try {
            ArrayList<LogRecord> result = new ArrayList<LogRecord>(this.count);
            for (int i = 0; i < this.count; ++i) {
                result.add(i, this.records[(this.position + i) % this.records.length]);
            }
            ArrayList<LogRecord> arrayList = result;
            return arrayList;
        }
        finally {
            this.outputLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setWriter(Writer writer) {
        this.outputLock.lock();
        try (Writer oldWriter = this.writer;){
            if (oldWriter != null) {
                try {
                    oldWriter.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.writer = writer;
        }
        catch (IOException iOException) {
        }
        finally {
            this.outputLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"}, justification="Best effort")
    private void setFile(File file) throws FileNotFoundException {
        this.outputLock.lock();
        try {
            if (file == null) {
                this.setWriter(null);
                return;
            }
            File parentFile = file.getParentFile();
            if (parentFile != null) {
                parentFile.mkdirs();
            }
            StreamUtils.closeQuietly(null);
            boolean success = false;
            FileOutputStream fos = null;
            BufferedOutputStream bos = null;
            OutputStreamWriter writer = null;
            try {
                fos = new FileOutputStream(file);
                bos = new BufferedOutputStream(fos);
                writer = new OutputStreamWriter((OutputStream)bos, StandardCharsets.UTF_8);
                this.setWriter(writer);
                this.fileCount = 0;
                success = true;
                if (success) return;
            }
            catch (Throwable throwable) {
                if (success) throw throwable;
                StreamUtils.closeQuietly(writer);
                StreamUtils.closeQuietly(bos);
                StreamUtils.closeQuietly(fos);
                throw throwable;
            }
            StreamUtils.closeQuietly(writer);
            StreamUtils.closeQuietly(bos);
            StreamUtils.closeQuietly(fos);
            return;
        }
        finally {
            this.outputLock.unlock();
        }
    }
}

