/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support;

import com.cloudbees.jenkins.support.BundleNameInstanceTypeProvider;
import com.cloudbees.jenkins.support.SupportPlugin;
import com.cloudbees.jenkins.support.api.SupportProvider;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Clock;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;

public final class BundleFileName {
    private static final Clock DEFAULT_CLOCK = Clock.systemUTC();
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd_HH.mm.ss");

    private BundleFileName() {
        throw new UnsupportedOperationException();
    }

    @NonNull
    public static String generate() {
        return BundleFileName.generate(DEFAULT_CLOCK, null);
    }

    @NonNull
    public static String generate(String qualifier) {
        return BundleFileName.generate(DEFAULT_CLOCK, qualifier);
    }

    static String generate(Clock clock, String qualifier) {
        String instanceType;
        Objects.requireNonNull(clock);
        StringBuilder filename = new StringBuilder();
        filename.append(BundleFileName.getSupportProviderName());
        if (qualifier != null && !qualifier.isBlank()) {
            filename.append('_').append(qualifier.trim());
        }
        if (!(instanceType = BundleNameInstanceTypeProvider.getInstance().getInstanceType()).isBlank()) {
            filename.append("_").append(instanceType);
        }
        filename.append("_").append(LocalDateTime.now(clock).format(DATE_TIME_FORMATTER));
        filename.append(".zip");
        return filename.toString();
    }

    private static String getSupportProviderName() {
        SupportProvider supportProvider;
        String filename = "support";
        SupportPlugin instance = SupportPlugin.getInstance();
        if (instance != null && (supportProvider = instance.getSupportProvider()) != null) {
            filename = supportProvider.getName();
        }
        return filename;
    }
}

