/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support.util;

import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;

public class WordReplacer {
    public static String replaceWords(String input, Pattern pattern, Map<String, String> replacements) {
        return WordReplacer.replaceWords(input, pattern, (String s) -> (String)replacements.get(s.toLowerCase(Locale.ENGLISH)));
    }

    public static String replaceWords(String input, Pattern pattern, Function<String, String> replace) {
        return pattern.matcher(input).replaceAll(matchResult -> (String)replace.apply(matchResult.group()));
    }

    public static String replaceWords(String input, String[] words, String[] replaces) {
        StringBuilder sb = new StringBuilder(input);
        WordReplacer.replaceWords(sb, words, replaces);
        return sb.toString();
    }

    public static String replaceWordsIgnoreCase(String input, String[] words, String[] replaces) {
        StringBuilder sb = new StringBuilder(input);
        WordReplacer.replaceWordsIgnoreCase(sb, words, replaces);
        return sb.toString();
    }

    public static void replaceWords(StringBuilder input, String[] words, String[] replaces) {
        WordReplacer.replaceWords(input, words, replaces, false);
    }

    public static void replaceWordsIgnoreCase(StringBuilder input, String[] words, String[] replaces) {
        WordReplacer.replaceWords(input, words, replaces, true);
    }

    private static void replaceWords(StringBuilder input, String[] words, String[] replaces, boolean ignoreCase) {
        if (input == null || input.length() == 0 || words == null || words.length == 0 || replaces == null || replaces.length == 0) {
            return;
        }
        if (words.length != replaces.length) {
            throw new IllegalArgumentException(String.format("Words (%d) and replaces (%d) lengths should be equals", words.length, replaces.length));
        }
        for (int i = 0; i < words.length; ++i) {
            WordReplacer.replaceWord(input, words[i], replaces[i], ignoreCase);
        }
    }

    public static String replaceWord(String input, String word, String replace) {
        StringBuilder sb = new StringBuilder(input);
        WordReplacer.replaceWord(sb, word, replace);
        return sb.toString();
    }

    public static String replaceWordIgnoreCase(String input, String word, String replace) {
        StringBuilder sb = new StringBuilder(input);
        WordReplacer.replaceWordIgnoreCase(sb, word, replace);
        return sb.toString();
    }

    public static void replaceWord(StringBuilder input, String word, String replace) {
        WordReplacer.replaceWord(input, word, replace, false);
    }

    public static void replaceWordIgnoreCase(StringBuilder input, String word, String replace) {
        WordReplacer.replaceWord(input, word, replace, true);
    }

    private static void replaceWord(StringBuilder input, String word, String replace, boolean ignoreCase) {
        String workWord;
        StringBuilder workInput;
        if (input == null || word == null || input.length() == 0 || word.length() == 0) {
            return;
        }
        if (replace == null) {
            replace = "";
        }
        if (ignoreCase) {
            workInput = new StringBuilder(input.toString().toLowerCase(Locale.ENGLISH));
            workWord = word.toLowerCase(Locale.ENGLISH);
        } else {
            workInput = new StringBuilder(input);
            workWord = word;
        }
        int pos = 0;
        while ((pos = workInput.indexOf(workWord, pos)) != -1) {
            char prevChar;
            if (pos > 0 && Character.isLetterOrDigit(prevChar = workInput.charAt(pos - 1))) {
                pos += workWord.length();
            } else {
                char nextChar;
                int nextPos = pos + workWord.length();
                if (nextPos < workInput.length() && Character.isLetterOrDigit(nextChar = workInput.charAt(nextPos))) {
                    pos += workWord.length();
                } else {
                    if (pos >= 0 && pos < input.length()) {
                        input.replace(pos, pos + workWord.length(), replace);
                        workInput.replace(pos, pos + workWord.length(), replace);
                    }
                    pos += replace.length();
                }
            }
            if (pos > -1 && pos < workInput.length()) continue;
        }
    }
}

