/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support.util;

import java.util.Locale;
import jenkins.security.MasterToSlaveCallable;

public enum SystemPlatform {
    LINUX,
    SOLARIS,
    WINDOWS,
    MACOSX,
    UNKNOWN;


    public static SystemPlatform current() {
        String arch = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
        if (arch.contains("linux")) {
            return LINUX;
        }
        if (arch.contains("windows")) {
            return WINDOWS;
        }
        if (arch.contains("sun") || arch.contains("solaris")) {
            return SOLARIS;
        }
        if (arch.contains("mac")) {
            return MACOSX;
        }
        return UNKNOWN;
    }

    public static class GetCurrentPlatform
    extends MasterToSlaveCallable<SystemPlatform, Exception> {
        private static final long serialVersionUID = 1L;

        public SystemPlatform call() {
            return SystemPlatform.current();
        }
    }
}

