/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support.util;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.BulkChange;
import hudson.XmlFile;
import hudson.model.Saveable;
import hudson.model.listeners.SaveableListener;
import java.io.File;
import java.io.IOException;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public final class Persistence {
    @NonNull
    public static <T extends Saveable> XmlFile getConfigFile(@NonNull Class<T> clazz) {
        return new XmlFile(new File(Jenkins.get().getRootDir(), clazz.getCanonicalName() + ".xml"));
    }

    public static <T extends Saveable> void save(@NonNull T object) throws IOException {
        if (!BulkChange.contains(object)) {
            XmlFile file = Persistence.getConfigFile(object.getClass());
            file.write(object);
            SaveableListener.fireOnChange(object, (XmlFile)file);
        }
    }

    @CheckForNull
    public static <T extends Saveable> T load(@NonNull Class<T> clazz) throws IOException {
        XmlFile file = Persistence.getConfigFile(clazz);
        return (T)(file.exists() ? (Saveable)clazz.cast(file.read()) : null);
    }

    private Persistence() {
    }
}

