/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support.timer;

import com.cloudbees.jenkins.support.api.Component;
import com.cloudbees.jenkins.support.api.Container;
import com.cloudbees.jenkins.support.api.FileContent;
import com.cloudbees.jenkins.support.timer.FileListCap;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.security.Permission;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import jenkins.model.Jenkins;
import org.apache.commons.io.FileUtils;

public abstract class FileListCapComponent
extends Component {
    public static final int MAX_FILE_SIZE = 2000000;
    public static final long MAX_LOG_FILE_AGE_MS = TimeUnit.DAYS.toMillis(90L);

    @Override
    @NonNull
    public Set<Permission> getRequiredPermissions() {
        return Collections.singleton(Jenkins.ADMINISTER);
    }

    @Override
    @NonNull
    public Component.ComponentCategory getCategory() {
        return Component.ComponentCategory.PLATFORM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addContents(@NonNull Container container, FileListCap fileListCap) {
        FileListCap fileListCap2 = fileListCap;
        synchronized (fileListCap2) {
            Collection files = FileUtils.listFiles((File)fileListCap.getFolder(), (String[])new String[]{"txt"}, (boolean)false);
            long recently = System.currentTimeMillis() - MAX_LOG_FILE_AGE_MS;
            for (File f : files) {
                if (f.lastModified() <= recently) continue;
                container.add(new FileContent("{0}/{1}", new String[]{fileListCap.getFolder().getName(), f.getName()}, f, 2000000L));
            }
        }
    }
}

