/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support.timer;

import com.cloudbees.jenkins.support.SupportPlugin;
import com.cloudbees.jenkins.support.filter.ContentFilter;
import com.cloudbees.jenkins.support.impl.ThreadDumps;
import com.cloudbees.jenkins.support.timer.FileListCap;
import hudson.Extension;
import hudson.model.PeriodicWork;
import java.io.File;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import jenkins.model.Jenkins;

@Extension
public class DeadlockTrackChecker
extends PeriodicWork {
    final SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd-HHmmss");
    final FileListCap logs;

    public DeadlockTrackChecker() {
        this.format.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.logs = new FileListCap(new File(Jenkins.get().getRootDir(), "deadlocks"), 50);
    }

    public long getRecurrencePeriod() {
        return TimeUnit.SECONDS.toMillis(15L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRun() throws Exception {
        long[] deadLocks;
        ThreadMXBean mbean = ManagementFactory.getThreadMXBean();
        try {
            deadLocks = mbean.findDeadlockedThreads();
        }
        catch (UnsupportedOperationException x) {
            deadLocks = null;
        }
        if (deadLocks != null && deadLocks.length != 0) {
            File file = this.logs.file("DeadlockDetected-" + this.format.format(new Date()) + ".txt");
            this.logs.add(file);
            try (PrintWriter builder = new PrintWriter(file, "UTF-8");){
                builder.println("==============");
                builder.println("Deadlock Found");
                builder.println("==============");
                ThreadInfo[] deadLockThreads = mbean.getThreadInfo(deadLocks, Integer.MAX_VALUE);
                ContentFilter contentFilter = SupportPlugin.getDefaultContentFilter();
                for (ThreadInfo threadInfo : deadLockThreads) {
                    try {
                        ThreadDumps.printThreadInfo(builder, threadInfo, mbean, contentFilter);
                    }
                    catch (LinkageError e) {
                        builder.println(threadInfo);
                    }
                }
            }
        }
    }
}

