/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support.slowrequest;

import com.cloudbees.jenkins.support.SupportPlugin;
import com.cloudbees.jenkins.support.impl.ThreadDumps;
import com.cloudbees.jenkins.support.timer.FileListCap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import java.io.File;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;

@Extension
public class SlowRequestThreadDumpsGenerator
extends Thread {
    private static long latestGeneratedSlowRequestThreadDump = 0L;
    private static AtomicBoolean running = new AtomicBoolean(false);
    public static final long RECURRENCE_PERIOD_MIN = Integer.getInteger(SlowRequestThreadDumpsGenerator.class.getName() + ".RECURRENCE_PERIOD_MIN", 10).intValue();
    private static final long RECURRENCE_PERIOD_MILLIS = RECURRENCE_PERIOD_MIN * 60000L;
    public static final int MINIMAL_SLOW_REQUEST_COUNT = Integer.getInteger(SlowRequestThreadDumpsGenerator.class.getName() + ".MINIMAL_SLOW_REQUEST_COUNT", 5);
    public static final int TOTAL_ITERATIONS = Integer.getInteger(SlowRequestThreadDumpsGenerator.class.getName() + ".TOTAL_ITERATIONS", 4);
    public static final int FREQUENCY_SEC = Integer.getInteger(SlowRequestThreadDumpsGenerator.class.getName() + ".FREQUENCY_SEC", 5);
    public static final int SLOW_REQUEST_THREAD_DUMPS_TO_RETAIN = Integer.getInteger(SlowRequestThreadDumpsGenerator.class.getName() + ".SLOW_REQUEST_THREAD_DUMPS_TO_RETAIN", 40);
    protected final FileListCap logs = new FileListCap(new File(SupportPlugin.getRootDirectory(), "slow-request-threaddumps"), SLOW_REQUEST_THREAD_DUMPS_TO_RETAIN);
    @SuppressFBWarnings
    public static boolean DISABLED = Boolean.getBoolean(SlowRequestThreadDumpsGenerator.class.getName() + ".DISABLED");
    private long iota = 0L;
    private static final Logger LOGGER = Logger.getLogger(SlowRequestThreadDumpsGenerator.class.getName());

    public SlowRequestThreadDumpsGenerator(long iota) {
        this.iota = iota;
    }

    public SlowRequestThreadDumpsGenerator() {
    }

    @Override
    public void run() {
        if (DISABLED) {
            return;
        }
        SlowRequestThreadDumpsGenerator.setRunningStatus(true);
        long fileNameDate = this.iota;
        ThreadDumps.collectMultiple(this.logs, fileNameDate, TimeUnit.SECONDS.toMillis(FREQUENCY_SEC), TOTAL_ITERATIONS);
        SlowRequestThreadDumpsGenerator.setRunningStatus(false);
    }

    public static synchronized boolean checkThreadDumpsTrigger(long iota) {
        boolean newThreadDumps = false;
        if (!(SlowRequestThreadDumpsGenerator.isRunning() || latestGeneratedSlowRequestThreadDump != 0L && iota - latestGeneratedSlowRequestThreadDump <= RECURRENCE_PERIOD_MILLIS)) {
            newThreadDumps = true;
            latestGeneratedSlowRequestThreadDump = iota;
        }
        return newThreadDumps;
    }

    private static boolean isRunning() {
        return running.get();
    }

    private static void setRunningStatus(boolean runningLocal) {
        running.set(runningLocal);
    }
}

