/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support.slowrequest;

import com.cloudbees.jenkins.support.SupportPlugin;
import com.cloudbees.jenkins.support.filter.ContentFilter;
import com.cloudbees.jenkins.support.slowrequest.InflightRequest;
import com.cloudbees.jenkins.support.slowrequest.SlowRequestFilter;
import com.cloudbees.jenkins.support.slowrequest.SlowRequestThreadDumpsGenerator;
import com.cloudbees.jenkins.support.timer.FileListCap;
import com.google.inject.Inject;
import hudson.Extension;
import hudson.model.PeriodicWork;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;

@Extension
public class SlowRequestChecker
extends PeriodicWork {
    public static final int RECURRENCE_PERIOD_SEC = Integer.getInteger(SlowRequestChecker.class.getName() + ".RECURRENCE_PERIOD_SEC", 3);
    public static final int THRESHOLD = Integer.getInteger(SlowRequestChecker.class.getName() + ".THRESHOLD_MS", 10000);
    public static volatile boolean DISABLED = Boolean.getBoolean(SlowRequestChecker.class.getName() + ".DISABLED");
    @Inject
    SlowRequestFilter filter;
    final FileListCap logs = new FileListCap(new File(Jenkins.get().getRootDir(), "slow-requests"), 50);
    final SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd-HHmmss.SSS");
    private static final Logger LOGGER = Logger.getLogger(SlowRequestChecker.class.getName());

    public SlowRequestChecker() {
        this.format.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public long getRecurrencePeriod() {
        return TimeUnit.SECONDS.toMillis(RECURRENCE_PERIOD_SEC);
    }

    protected void doRun() throws Exception {
        boolean newThreadDumps;
        if (DISABLED || this.filter.tracker.isEmpty()) {
            return;
        }
        long now = System.currentTimeMillis();
        long iota = System.currentTimeMillis();
        long recurrencePeriosMillis = TimeUnit.SECONDS.toMillis(RECURRENCE_PERIOD_SEC);
        long thresholdMillis = recurrencePeriosMillis > (long)THRESHOLD ? recurrencePeriosMillis * 2L : (long)THRESHOLD;
        ContentFilter contentFilter = SupportPlugin.getDefaultContentFilter();
        int slowRequestCount = 0;
        for (InflightRequest req : this.filter.tracker.values()) {
            long totalTime = now - req.startTime;
            if (totalTime <= thresholdMillis || req.ended) continue;
            boolean newRecord = req.record == null;
            ++slowRequestCount;
            if (newRecord) {
                req.record = this.logs.file(this.format.format(new Date(iota++)) + ".txt");
                this.logs.add(req.record);
            } else {
                this.logs.touch(req.record);
            }
            try (PrintWriter w = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(req.record, !newRecord), StandardCharsets.UTF_8));){
                ThreadInfo lockedThread;
                if (newRecord) {
                    req.writeHeader(w, contentFilter);
                }
                if (req.record.length() >= 2000000L || (lockedThread = ManagementFactory.getThreadMXBean().getThreadInfo(req.thread.getId(), Integer.MAX_VALUE)) == null) continue;
                w.println(contentFilter.filter(lockedThread.toString()));
                w.println(totalTime + "msec elapsed in " + contentFilter.filter(lockedThread.getThreadName()));
                this.printThreadStackElements(lockedThread, w, contentFilter);
                long lockOwnerId = lockedThread.getLockOwnerId();
                if (lockOwnerId == -1L) continue;
                ThreadInfo threadInfo = ManagementFactory.getThreadMXBean().getThreadInfo(lockOwnerId, Integer.MAX_VALUE);
                w.println(contentFilter.filter(lockedThread.toString()));
                if (threadInfo == null) continue;
                this.printThreadStackElements(threadInfo, w, contentFilter);
            }
        }
        if (slowRequestCount >= SlowRequestThreadDumpsGenerator.MINIMAL_SLOW_REQUEST_COUNT && (newThreadDumps = SlowRequestThreadDumpsGenerator.checkThreadDumpsTrigger(iota))) {
            try {
                SlowRequestThreadDumpsGenerator slowRequestThreadDumpsGenerator = new SlowRequestThreadDumpsGenerator(iota);
                slowRequestThreadDumpsGenerator.start();
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Support Core plugin can't throw a new thread to collect thread dumps under SlowRequest scenario", e);
            }
        }
    }

    private void printThreadStackElements(ThreadInfo threadinfo, PrintWriter writer, ContentFilter contentFilter) {
        for (StackTraceElement element : threadinfo.getStackTrace()) {
            writer.println("    " + contentFilter.filter(element.toString()));
        }
    }
}

