/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support.slowrequest;

import com.cloudbees.jenkins.support.filter.ContentFilter;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.PrintWriter;
import java.util.Date;
import jenkins.model.Jenkins;
import net.sf.uadetector.service.UADetectorServiceFactory;

final class InflightRequest {
    final Thread thread = Thread.currentThread();
    final long startTime;
    final String url;
    volatile boolean ended;
    File record;
    final String userName;
    final String referer;
    private final String userAgent;
    final String locale;

    InflightRequest(HttpServletRequest req) {
        String query = req.getQueryString();
        this.url = String.valueOf(req.getRequestURL()) + (String)(query == null ? "" : "?" + query);
        this.startTime = System.currentTimeMillis();
        this.userName = Jenkins.getAuthentication().getName();
        this.referer = req.getHeader("Referer");
        this.userAgent = req.getHeader("User-Agent");
        this.locale = req.getLocale().toString();
    }

    void writeHeader(PrintWriter w, ContentFilter filter) {
        w.println("Username: " + filter.filter(this.userName));
        w.println("Referer: " + filter.filter(this.referer));
        w.println("User Agent: " + String.valueOf(this.userAgent != null ? UADetectorServiceFactory.getResourceModuleParser().parse(this.userAgent) : null));
        w.println("Date: " + String.valueOf(new Date()));
        w.println("URL: " + filter.filter(this.url));
        w.println("Locale: " + this.locale);
        w.println();
    }
}

