/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support.impl;

import com.cloudbees.jenkins.support.api.Component;
import com.cloudbees.jenkins.support.api.Container;
import com.cloudbees.jenkins.support.api.PrintedContent;
import com.cloudbees.jenkins.support.timer.UnfilteredFileListCapComponent;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.User;
import hudson.security.Permission;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import jenkins.security.LastGrantedAuthoritiesProperty;

@Extension
public class UserCount
extends UnfilteredFileListCapComponent {
    @Override
    @NonNull
    public Set<Permission> getRequiredPermissions() {
        return Collections.singleton(Jenkins.ADMINISTER);
    }

    @Override
    @NonNull
    public String getDisplayName() {
        return "User Count";
    }

    @Override
    public void addContents(@NonNull Container result) {
        result.add(new PrintedContent("users/count.md"){

            @Override
            protected void printTo(PrintWriter out) {
                Jenkins jenkins = Jenkins.getInstanceOrNull();
                if (jenkins == null) {
                    return;
                }
                User.getAll().stream().collect(Collectors.groupingBy(user -> Optional.ofNullable((LastGrantedAuthoritiesProperty)user.getProperty(LastGrantedAuthoritiesProperty.class)).isPresent(), Collectors.counting())).forEach((lastGrantedAuthoritiesProperty, aLong) -> out.println(" * " + (lastGrantedAuthoritiesProperty != false ? "Authenticated" : "Non Authenticated") + " User Count: " + aLong));
            }

            @Override
            public boolean shouldBeFiltered() {
                return false;
            }
        });
    }

    @Override
    public boolean isSelectedByDefault() {
        return true;
    }

    @Override
    @NonNull
    public Component.ComponentCategory getCategory() {
        return Component.ComponentCategory.MISC;
    }
}

