/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support.impl;

import com.cloudbees.jenkins.support.api.Component;
import com.cloudbees.jenkins.support.api.Container;
import com.cloudbees.jenkins.support.api.FileContent;
import com.cloudbees.jenkins.support.impl.JenkinsLogs;
import com.cloudbees.jenkins.support.timer.FileListCapComponent;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.security.Permission;
import hudson.triggers.SafeTimerTask;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import jenkins.model.Jenkins;

@Extension(ordinal=100.0)
public class TaskLogs
extends Component {
    @Override
    @NonNull
    public Set<Permission> getRequiredPermissions() {
        return Collections.singleton(Jenkins.ADMINISTER);
    }

    @Override
    @NonNull
    public String getDisplayName() {
        return "Controller Task Log Recorders";
    }

    @Override
    public boolean isSelectedByDefault() {
        return true;
    }

    @Override
    public void addContents(@NonNull Container result) {
        this.addControllerTasksLogs(result);
    }

    @Override
    @NonNull
    public Component.ComponentCategory getCategory() {
        return Component.ComponentCategory.LOGS;
    }

    private void addControllerTasksLogs(Container result) {
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        if (jenkins != null) {
            File logsRoot = SafeTimerTask.getLogsRoot();
            for (File logs : new File[]{logsRoot, new File(logsRoot, "tasks")}) {
                Object[] files = logs.listFiles(JenkinsLogs.ROTATED_LOGFILE_FILTER);
                if (files == null) continue;
                Arrays.sort(files);
                long recently = System.currentTimeMillis() - FileListCapComponent.MAX_LOG_FILE_AGE_MS;
                for (Object f : files) {
                    if (((File)f).getName().startsWith("Periodic background build discarder.log") || ((File)f).lastModified() <= recently) continue;
                    result.add(new FileContent("task-logs/{0}", new String[]{((File)f).getName()}, (File)f));
                }
            }
        }
    }
}

