/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support.impl;

import com.cloudbees.jenkins.support.AsyncResultCache;
import com.cloudbees.jenkins.support.api.CommandOutputContent;
import com.cloudbees.jenkins.support.api.Component;
import com.cloudbees.jenkins.support.api.Container;
import com.cloudbees.jenkins.support.api.ObjectComponentDescriptor;
import com.cloudbees.jenkins.support.api.UnfilteredCommandOutputContent;
import com.cloudbees.jenkins.support.api.UnfilteredStringContent;
import com.cloudbees.jenkins.support.impl.AdvancedProcFilesRetriever;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractModelObject;
import hudson.model.Computer;
import hudson.model.Node;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.security.MasterToSlaveCallable;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public abstract class SystemConfiguration
extends AdvancedProcFilesRetriever {
    private final WeakHashMap<Node, String> sysCtlCache = new WeakHashMap();
    private final WeakHashMap<Node, String> userIdCache = new WeakHashMap();
    private final WeakHashMap<Node, String> dmiCache = new WeakHashMap();
    private static final Logger LOGGER = Logger.getLogger(SystemConfiguration.class.getName());
    private static final Set<AdvancedProcFilesRetriever.ProcFile> UNIX_PROC_CONTENTS;

    @Override
    public Set<AdvancedProcFilesRetriever.ProcFile> getProcFilesToRetrieve() {
        return UNIX_PROC_CONTENTS;
    }

    @Override
    protected void afterAddUnixContents(@NonNull Container container, @NonNull Node node, String name) {
        container.add(UnfilteredCommandOutputContent.runOnNodeAndCache(this.sysCtlCache, node, "nodes/{0}/sysctl.txt", new String[]{name}, new String[]{"/bin/sh", "-c", "sysctl -a"}));
        container.add(UnfilteredCommandOutputContent.runOnNode(node, "nodes/{0}/dmesg.txt", new String[]{name}, new String[]{"/bin/sh", "-c", "(dmesg --ctime 2>/dev/null||dmesg) |tail -1000"}));
        container.add(CommandOutputContent.runOnNodeAndCache(this.userIdCache, node, "nodes/{0}/userid.txt", new String[]{name}, new String[]{"/bin/sh", "-c", "id -a"}));
        container.add(new UnfilteredStringContent("nodes/{0}/dmi.txt", new String[]{name}, this.getDmiInfo(node)));
    }

    public String getDmiInfo(Node node) {
        try {
            return AsyncResultCache.get(node, this.dmiCache, new GetDmiInfo(), "dmi", "");
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, "Could not retrieve dmi content from " + SystemConfiguration.getNodeName(node), e);
            return "no dmi info";
        }
    }

    static {
        HashSet<AdvancedProcFilesRetriever.ProcFile> contents = new HashSet<AdvancedProcFilesRetriever.ProcFile>();
        contents.add(AdvancedProcFilesRetriever.ProcFile.of("/proc/swaps", "swaps.txt", false));
        contents.add(AdvancedProcFilesRetriever.ProcFile.of("/proc/cpuinfo", "cpuinfo.txt", false));
        contents.add(AdvancedProcFilesRetriever.ProcFile.of("/proc/mounts", "mounts.txt", false));
        contents.add(AdvancedProcFilesRetriever.ProcFile.of("/proc/uptime", "system-uptime.txt", false));
        contents.add(AdvancedProcFilesRetriever.ProcFile.of("/proc/net/rpc/nfs", "net/rpc/nfs.txt", false));
        contents.add(AdvancedProcFilesRetriever.ProcFile.of("/proc/net/rpc/nfsd", "net/rpc/nfsd.txt", false));
        UNIX_PROC_CONTENTS = Collections.unmodifiableSet(contents);
    }

    @SuppressFBWarnings(value={"DMI_HARDCODED_ABSOLUTE_FILENAME"})
    public static class GetDmiInfo
    extends MasterToSlaveCallable<String, Exception> {
        private static final long serialVersionUID = 1L;

        public String call() {
            StringBuilder sb = new StringBuilder();
            File[] files = new File("/sys/devices/virtual/dmi/id").listFiles();
            if (files != null) {
                for (File file : files) {
                    if (!file.canRead() || file.isDirectory()) continue;
                    sb.append(file.getName());
                    sb.append(": ");
                    try {
                        sb.append(Util.loadFile((File)file, (Charset)Charset.defaultCharset()).trim());
                    }
                    catch (IOException e) {
                        sb.append("failed, " + e.getMessage());
                    }
                    sb.append('\n');
                }
            }
            return sb.toString();
        }
    }

    @Extension
    public static class Agents
    extends SystemConfiguration {
        @DataBoundConstructor
        public Agents() {
        }

        @Override
        @NonNull
        public String getDisplayName() {
            return "Agent system configuration (Linux only)";
        }

        @Override
        public boolean isSelectedByDefault() {
            return false;
        }

        @Override
        @NonNull
        public Component.ComponentCategory getCategory() {
            return Component.ComponentCategory.AGENT;
        }

        @Override
        protected List<Node> getNodes() {
            return Jenkins.get().getNodes();
        }

        @Override
        public <C extends AbstractModelObject> boolean isApplicable(Class<C> clazz) {
            return Jenkins.class.isAssignableFrom(clazz) || Computer.class.isAssignableFrom(clazz);
        }

        @Override
        public boolean isApplicable(Computer item) {
            return item != Jenkins.get().toComputer();
        }

        @Override
        public DescriptorImpl getDescriptor() {
            return (DescriptorImpl)Jenkins.get().getDescriptorByType(DescriptorImpl.class);
        }

        @Override
        @NonNull
        public String getId() {
            return "AgentsSystemConfiguration";
        }

        @Extension
        @Symbol(value={"agentSystemConfigurationComponent"})
        public static class DescriptorImpl
        extends ObjectComponentDescriptor<Computer> {
            @NonNull
            public String getDisplayName() {
                return "Agent system configuration (Linux only)";
            }
        }
    }

    @Extension
    public static class Master
    extends SystemConfiguration {
        @DataBoundConstructor
        public Master() {
        }

        @Override
        @NonNull
        public String getDisplayName() {
            return "Controller system configuration (Linux only)";
        }

        @Override
        protected List<Node> getNodes() {
            return Collections.singletonList(Jenkins.get());
        }

        @Override
        public <C extends AbstractModelObject> boolean isApplicable(Class<C> clazz) {
            return Jenkins.class.isAssignableFrom(clazz);
        }

        @Override
        public boolean isApplicable(Computer item) {
            return item == Jenkins.get().toComputer();
        }

        @Override
        public DescriptorImpl getDescriptor() {
            return (DescriptorImpl)Jenkins.get().getDescriptorByType(DescriptorImpl.class);
        }

        @Override
        @NonNull
        public String getId() {
            return "MasterSystemConfiguration";
        }

        @Extension
        @Symbol(value={"masterSystemConfigurationComponent"})
        public static class DescriptorImpl
        extends ObjectComponentDescriptor<Computer> {
            @NonNull
            public String getDisplayName() {
                return "Controller system configuration (Linux only)";
            }
        }
    }
}

