/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support.impl;

import com.cloudbees.jenkins.support.SupportPlugin;
import com.cloudbees.jenkins.support.util.StreamUtils;
import hudson.FilePath;
import hudson.Util;
import hudson.model.Node;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.MasterToSlaveFileCallable;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.IOUtils;

class SmartLogFetcher {
    private final File rootCacheDir;
    private final FilenameFilter filter;
    private static final Logger LOGGER = Logger.getLogger(SmartLogFetcher.class.getName());

    public SmartLogFetcher(String id, FilenameFilter filter) {
        this.rootCacheDir = new File(SupportPlugin.getLogsDirectory(), id);
        this.filter = filter;
        assert (filter instanceof Serializable);
    }

    public ForNode forNode(Node n) throws IOException {
        return new ForNode(n);
    }

    class ForNode {
        private final Node node;
        private final File cacheDir;

        ForNode(Node node) throws IOException {
            this.node = node;
            String cacheKey = Util.getDigestOf((String)(node.getNodeName() + ":" + String.valueOf(node.getRootPath())));
            this.cacheDir = new File(SmartLogFetcher.this.rootCacheDir, cacheKey.substring(cacheKey.length() - 8));
            if (!this.cacheDir.isDirectory() && !this.cacheDir.mkdirs()) {
                throw new IOException("Could not create local cache directory: " + String.valueOf(this.cacheDir));
            }
        }

        public Map<String, File> getLogFiles(FilePath remoteDir) throws InterruptedException, IOException {
            File localCache = this.cacheDir;
            LinkedHashMap<String, FileHash> hashes = new LinkedHashMap<String, FileHash>();
            File[] localCacheFiles = localCache.listFiles(SmartLogFetcher.this.filter);
            if (localCacheFiles != null) {
                for (File file : localCacheFiles) {
                    hashes.put(file.getName(), new FileHash(file));
                }
            }
            Map offsets = (Map)remoteDir.act((FilePath.FileCallable)new LogFileHashSlurper(hashes, SmartLogFetcher.this.filter));
            this.evictDeadCache(hashes, offsets);
            LinkedHashMap<String, File> result = new LinkedHashMap<String, File>();
            for (Map.Entry entry : offsets.entrySet()) {
                File local = new File(localCache, (String)entry.getKey());
                if ((Long)entry.getValue() > 0L && local.isFile()) {
                    long localLength = local.length();
                    if ((Long)entry.getValue() < Long.MAX_VALUE) {
                        try (FileOutputStream fos = new FileOutputStream(local, true);
                             InputStream is = remoteDir.child((String)entry.getKey()).readFromOffset(localLength);){
                            IOUtils.copy((InputStream)is, (OutputStream)fos);
                        }
                    }
                    result.put((String)entry.getKey(), local);
                    continue;
                }
                try (FileOutputStream fos = new FileOutputStream(local, false);
                     InputStream is = remoteDir.child((String)entry.getKey()).read();){
                    IOUtils.copy((InputStream)is, (OutputStream)fos);
                }
                result.put((String)entry.getKey(), local);
            }
            return result;
        }

        private void evictDeadCache(Map<String, FileHash> hashes, Map<String, Long> offsets) {
            for (String key : hashes.keySet()) {
                File deadCacheFile;
                if (offsets.containsKey(key) || (deadCacheFile = new File(this.cacheDir, key)).delete()) continue;
                LOGGER.log(Level.WARNING, "Unable to delete redundant cache file: {0}", deadCacheFile);
            }
        }
    }

    public static final class LogFileHashSlurper
    extends MasterToSlaveFileCallable<Map<String, Long>> {
        private final Map<String, FileHash> cached;
        private final FilenameFilter filter;

        public LogFileHashSlurper(Map<String, FileHash> cached, FilenameFilter filter) {
            this.cached = cached;
            this.filter = filter;
        }

        public Map<String, Long> invoke(File dir, VirtualChannel channel) throws IOException, InterruptedException {
            LinkedHashMap<String, Long> result = new LinkedHashMap<String, Long>();
            File[] files = dir.listFiles(this.filter);
            if (files == null) {
                return result;
            }
            for (File file : files) {
                FileHash hash = this.cached.get(file.getName());
                if (hash != null && hash.isPartialMatch(file)) {
                    if (file.length() == hash.getLength()) {
                        result.put(file.getName(), Long.MAX_VALUE);
                        continue;
                    }
                    result.put(file.getName(), hash.getLength());
                    continue;
                }
                result.put(file.getName(), 0L);
            }
            return result;
        }
    }

    public static final class FileHash
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private static final String ZERO_LENGTH_MD5 = "d41d8cd98f00b204e9800998ecf8427e";
        private final long length;
        private final String md5;

        public FileHash(long length, String md5) {
            this.length = length;
            this.md5 = md5;
        }

        public FileHash(File file) throws IOException {
            this.length = file.length();
            this.md5 = FileHash.getDigestOf(new FileInputStream(file), this.length);
        }

        public FileHash(FilePath file) throws IOException, InterruptedException {
            this.length = file.length();
            this.md5 = FileHash.getDigestOf(file.read(), this.length);
        }

        public long getLength() {
            return this.length;
        }

        public String getMd5() {
            return this.md5;
        }

        public boolean isPartialMatch(File file) throws IOException {
            if (file.length() < this.length) {
                return false;
            }
            return this.md5.equals(FileHash.getDigestOf(new FileInputStream(file), this.length));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static String getDigestOf(InputStream stream, long length) throws IOException {
            try {
                int read;
                if (length == 0L || stream == null) {
                    String string = ZERO_LENGTH_MD5;
                    return string;
                }
                int bufferSize = length < 8192L ? (int)length : (length > 65536L ? 65536 : 8192);
                byte[] buffer = new byte[bufferSize];
                MessageDigest digest = null;
                try {
                    digest = MessageDigest.getInstance("md5");
                }
                catch (NoSuchAlgorithmException e) {
                    throw new IllegalStateException("Java Language Specification mandates MD5 as a supported digest", e);
                }
                while (length > 0L && (read = stream.read(buffer, 0, (int)Math.min((long)bufferSize, length))) != -1) {
                    digest.update(buffer, 0, read);
                    length -= (long)read;
                }
                String string = Hex.encodeHexString((byte[])digest.digest());
                return string;
            }
            finally {
                StreamUtils.closeQuietly(stream);
            }
        }
    }
}

