/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support.impl;

import com.cloudbees.jenkins.support.api.Component;
import com.cloudbees.jenkins.support.api.Container;
import com.cloudbees.jenkins.support.api.PrintedContent;
import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.FilePath;
import hudson.Util;
import hudson.model.Computer;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.remoting.Channel;
import hudson.remoting.Command;
import hudson.remoting.Request;
import hudson.remoting.Response;
import hudson.security.Permission;
import hudson.slaves.ComputerListener;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.annotation.Nonnegative;
import jenkins.model.Jenkins;
import jenkins.model.NodeListener;
import jenkins.util.SystemProperties;
import net.jcip.annotations.GuardedBy;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Extension
public final class SlaveCommandStatistics
extends Component {
    @Nonnegative
    static int MAX_STATS_SIZE = 1000;
    @Nonnegative
    static int MAX_COMMAND_LENGTH = SystemProperties.getInteger((String)(SlaveCommandStatistics.class.getName() + ".maxCommandLength"), (Integer)256);
    @Nonnegative
    static int MAX_ENTRIES_PER_AGENT = SystemProperties.getInteger((String)(SlaveCommandStatistics.class.getName() + ".maxEntriesPerAgent"), (Integer)1000);
    private final Object statLock = new Object();
    @GuardedBy(value="statLock")
    private final Map<String, Statistics> statistics = new HashMap<String, Statistics>();
    @GuardedBy(value="statLock")
    private final LinkedHashMap<String, Statistics> statLog = new LinkedHashMap();

    @Override
    public String getDisplayName() {
        return "Agent Command Statistics";
    }

    @Override
    public Set<Permission> getRequiredPermissions() {
        return Collections.singleton(Jenkins.ADMINISTER);
    }

    @Override
    public void addContents(Container container) {
        this.getStatistics().forEach((name, stats) -> container.add(new PrintedContent("nodes/slave/{0}/command-stats.md", new String[]{name}, (Statistics)((Object)stats)){
            final /* synthetic */ Statistics val$stats;
            {
                this.val$stats = statistics;
                super(name, filterableParameters);
            }

            @Override
            protected void printTo(PrintWriter out) throws IOException {
                this.val$stats.print(out);
            }

            @Override
            public boolean shouldBeFiltered() {
                return false;
            }
        }));
    }

    @Override
    @NonNull
    public Component.ComponentCategory getCategory() {
        return Component.ComponentCategory.AGENT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    Map<String, Statistics> getStatistics() {
        Object object = this.statLock;
        synchronized (object) {
            TreeMap<String, Statistics> out = new TreeMap<String, Statistics>();
            out.putAll(this.statistics);
            out.putAll(this.statLog);
            return out;
        }
    }

    @VisibleForTesting
    static final class Statistics
    extends Channel.Listener {
        private static final Logger LOGGER = Logger.getLogger(Statistics.class.getName());
        private final Map<String, CountSum> writes = new HashMap<String, CountSum>();
        private final Map<String, CountSum> reads = new HashMap<String, CountSum>();
        private final Map<String, CountSum> responses = new HashMap<String, CountSum>();
        private final Set<File> jars = new LinkedHashSet<File>();
        private static final Pattern IRRELEVANT = Pattern.compile("(\\[.{0,1048576}\\]|@[a-f0-9]+|[(][^)]+[)])+$");

        Statistics() {
        }

        private static void preferringOlder(Map<String, CountSum> map, String key, long value) {
            CountSum cs = map.get(key);
            if (cs != null) {
                cs.tally(value);
            } else if (map.size() < MAX_ENTRIES_PER_AGENT) {
                cs = new CountSum();
                cs.tally(value);
                map.put(key, cs);
            } else {
                LOGGER.log(Level.FINE, () -> "Statistics map at capacity (%d), ignoring command type: %s".formatted(MAX_ENTRIES_PER_AGENT, key));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onWrite(Channel channel, Command cmd, long blockSize) {
            String type = Statistics.classify(cmd);
            Map<String, CountSum> map = this.writes;
            synchronized (map) {
                Statistics.preferringOlder(this.writes, type, blockSize);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onRead(Channel channel, Command cmd, long blockSize) {
            String type = Statistics.classify(cmd);
            Map<String, CountSum> map = this.reads;
            synchronized (map) {
                Statistics.preferringOlder(this.reads, type, blockSize);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onResponse(Channel channel, Request<?, ?> req, Response<?, ?> rsp, long totalTime) {
            String type = Statistics.classify(req);
            Map<String, CountSum> map = this.responses;
            synchronized (map) {
                Statistics.preferringOlder(this.responses, type, totalTime);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onJar(Channel channel, File jar) {
            Set<File> set = this.jars;
            synchronized (set) {
                this.jars.add(jar);
            }
        }

        private static String classify(Command cmd) {
            return Statistics.classify(cmd.toString());
        }

        @VisibleForTesting
        static String classify(String cmdString) {
            if (((String)(cmdString = IRRELEVANT.matcher((CharSequence)cmdString).replaceFirst(""))).length() > MAX_COMMAND_LENGTH) {
                cmdString = ((String)cmdString).substring(0, MAX_COMMAND_LENGTH) + "...";
            }
            return cmdString;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void print(PrintWriter out) {
            out.println("# Totals");
            Map<String, CountSum> map = this.writes;
            synchronized (map) {
                out.printf("* Writes: %d%n  * sent %.1fMb%n", this.writes.values().stream().mapToLong(CountSum::count).sum(), (double)this.writes.values().stream().mapToLong(CountSum::sum).sum() / 1000000.0);
            }
            map = this.reads;
            synchronized (map) {
                out.printf("* Reads: %d%n  * received %.1fMb%n", this.reads.values().stream().mapToLong(CountSum::count).sum(), (double)this.reads.values().stream().mapToLong(CountSum::sum).sum() / 1000000.0);
            }
            map = this.responses;
            synchronized (map) {
                out.printf("* Responses: %d%n  * waited %s%n", this.responses.values().stream().mapToLong(CountSum::count).sum(), Util.getTimeSpanString((long)(this.responses.values().stream().mapToLong(CountSum::sum).sum() / 1000000L)));
            }
            out.println();
            out.println("# Commands sent");
            new TreeMap<String, CountSum>(this.writes).forEach((type, cs) -> out.printf("* `%s`: %d%n  * sent %.1fMb%n", type, cs.count, (double)cs.sum / 1000000.0));
            out.println();
            out.println("# Commands received");
            new TreeMap<String, CountSum>(this.reads).forEach((type, cs) -> out.printf("* `%s`: %d%n  * received %.1fMb%n", type, cs.count, (double)cs.sum / 1000000.0));
            out.println();
            out.println("# Responses received");
            new TreeMap<String, CountSum>(this.responses).forEach((type, cs) -> out.printf("* `%s`: %d%n  * waited %s%n", type, cs.count, Util.getTimeSpanString((long)(cs.sum / 1000000L))));
            out.println();
            out.println("# JARs sent");
            this.jars.forEach(jar -> out.printf("* `%s`: %db%n", jar.getName(), jar.length()));
        }

        private static final class CountSum {
            long count;
            long sum;

            private CountSum() {
            }

            void tally(long value) {
                ++this.count;
                this.sum += value;
            }

            long count() {
                return this.count;
            }

            long sum() {
                return this.sum;
            }
        }
    }

    @Extension
    @Restricted(value={NoExternalUse.class})
    public static final class NodeListenerImpl
    extends NodeListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onDeleted(@NonNull Node node) {
            SlaveCommandStatistics scs = (SlaveCommandStatistics)ExtensionList.lookupSingleton(SlaveCommandStatistics.class);
            Object object = scs.statLock;
            synchronized (object) {
                Statistics listener = scs.statistics.remove(node.getNodeName());
                if (MAX_STATS_SIZE > 0 && listener != null) {
                    LinkedHashMap<String, Statistics> log = scs.statLog;
                    while (log.size() >= MAX_STATS_SIZE) {
                        String head = log.keySet().iterator().next();
                        log.remove(head);
                    }
                    log.put(node.getNodeName(), listener);
                }
            }
        }
    }

    @Extension
    public static final class ComputerListenerImpl
    extends ComputerListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void preOnline(Computer c, Channel channel, FilePath root, TaskListener listener) throws IOException, InterruptedException {
            SlaveCommandStatistics scs = (SlaveCommandStatistics)ExtensionList.lookupSingleton(SlaveCommandStatistics.class);
            Object object = scs.statLock;
            synchronized (object) {
                channel.addListener((Channel.Listener)scs.statistics.computeIfAbsent(c.getName(), k -> new Statistics()));
            }
        }
    }
}

