/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support.impl;

import com.cloudbees.jenkins.support.api.Component;
import com.cloudbees.jenkins.support.api.Container;
import com.cloudbees.jenkins.support.api.PrintedContent;
import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.security.Permission;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest2;

@Extension
public class ReverseProxy
extends Component {
    private static final String FORWARDED_HEADER = "Forwarded";
    private static final String X_FORWARDED_FOR_HEADER = "X-Forwarded-For";
    private static final String X_FORWARDED_PROTO_HEADER = "X-Forwarded-Proto";
    private static final String X_FORWARDED_HOST_HEADER = "X-Forwarded-Host";
    private static final String X_FORWARDED_PORT_HEADER = "X-Forwarded-Port";
    static final Collection<String> FORWARDED_HEADERS = ImmutableList.of((Object)"Forwarded", (Object)"X-Forwarded-For", (Object)"X-Forwarded-Proto", (Object)"X-Forwarded-Host", (Object)"X-Forwarded-Port");

    @Override
    public boolean canBeGeneratedAsync() {
        return false;
    }

    @Override
    @NonNull
    public Set<Permission> getRequiredPermissions() {
        return Collections.singleton(Jenkins.ADMINISTER);
    }

    @Override
    @NonNull
    public String getDisplayName() {
        return "Reverse Proxy";
    }

    @Override
    public void addContents(@NonNull Container container) {
        container.add(new PrintedContent("reverse-proxy.md"){

            @Override
            protected void printTo(PrintWriter out) {
                out.println("Reverse Proxy");
                out.println("=============");
                StaplerRequest2 currentRequest = ReverseProxy.this.getCurrentRequest();
                for (String forwardedHeader : FORWARDED_HEADERS) {
                    out.println(String.format(" * Detected `%s` header: %s", new Object[]{forwardedHeader, ReverseProxy.this.isForwardedHeaderDetected(currentRequest, forwardedHeader)}));
                }
            }

            @Override
            public boolean shouldBeFiltered() {
                return false;
            }
        });
    }

    @Override
    @NonNull
    public Component.ComponentCategory getCategory() {
        return Component.ComponentCategory.PLATFORM;
    }

    private Trilean isForwardedHeaderDetected(StaplerRequest2 req, String header) {
        if (req == null) {
            return Trilean.UNKNOWN;
        }
        return req.getHeader(header) != null ? Trilean.TRUE : Trilean.FALSE;
    }

    protected StaplerRequest2 getCurrentRequest() {
        return Stapler.getCurrentRequest2();
    }

    public static enum Trilean {
        TRUE,
        FALSE,
        UNKNOWN;

    }
}

