/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support.impl;

import com.cloudbees.jenkins.support.api.Component;
import com.cloudbees.jenkins.support.api.Container;
import com.cloudbees.jenkins.support.api.PrintedContent;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Functions;
import hudson.remoting.Channel;
import hudson.security.Permission;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Set;
import jenkins.model.Jenkins;

public class RemotingDiagnostics
extends Component {
    @Override
    @NonNull
    public Set<Permission> getRequiredPermissions() {
        return Collections.singleton(Jenkins.ADMINISTER);
    }

    @Override
    @NonNull
    public String getDisplayName() {
        return "Remoting Channel Diagnostics";
    }

    @Override
    public void addContents(@NonNull Container container) {
        container.add(new PrintedContent("channel-diagnostics.md"){

            @Override
            protected void printTo(PrintWriter out) throws IOException {
                try {
                    Method m = Channel.class.getMethod("dumpDiagnosticsForAll", PrintWriter.class);
                    m.invoke(null, out);
                }
                catch (Exception e) {
                    Functions.printStackTrace((Throwable)e, (PrintWriter)out);
                }
            }

            @Override
            public boolean shouldBeFiltered() {
                return false;
            }
        });
    }

    @Override
    @NonNull
    public Component.ComponentCategory getCategory() {
        return Component.ComponentCategory.AGENT;
    }
}

