/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support.impl;

import com.cloudbees.jenkins.support.api.Component;
import com.cloudbees.jenkins.support.api.Container;
import com.cloudbees.jenkins.support.api.PrefilteredPrintedContent;
import com.cloudbees.jenkins.support.filter.ContentFilter;
import com.cloudbees.jenkins.support.util.Markdown;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.security.Permission;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import jenkins.model.Jenkins;

@Extension
public class ProxyConfiguration
extends Component {
    @Override
    @NonNull
    public Set<Permission> getRequiredPermissions() {
        return Collections.singleton(Jenkins.ADMINISTER);
    }

    @Override
    @NonNull
    public String getDisplayName() {
        return "Proxy Configuration";
    }

    @Override
    public void addContents(@NonNull Container container) {
        container.add(new PrefilteredPrintedContent("proxy.md"){

            @Override
            public void printTo(PrintWriter out, @NonNull ContentFilter filter) {
                out.println("Proxy");
                out.println("===============");
                out.println();
                hudson.ProxyConfiguration proxy = Jenkins.get().getProxy();
                if (proxy != null) {
                    out.println("  - Host: `" + Markdown.escapeBacktick(ContentFilter.filter(filter, proxy.getName())) + "`");
                    out.println("  - Port: `" + proxy.getPort() + "`");
                    out.println("  - No Proxy Hosts: ");
                    String noProxyHostsString = proxy.getNoProxyHost();
                    if (noProxyHostsString != null) {
                        Arrays.stream(noProxyHostsString.split("[ \t\n,|]+")).forEach(noProxyHost -> out.println("      * `" + Markdown.escapeBacktick(ContentFilter.filter(filter, noProxyHost)) + "`"));
                    }
                }
            }
        });
    }

    @Override
    @NonNull
    public Component.ComponentCategory getCategory() {
        return Component.ComponentCategory.CONTROLLER;
    }
}

