/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support.impl;

import com.cloudbees.jenkins.support.api.Component;
import com.cloudbees.jenkins.support.api.Container;
import com.cloudbees.jenkins.support.api.FilePathContent;
import com.cloudbees.jenkins.support.impl.DirectoryComponent;
import com.cloudbees.jenkins.support.impl.Messages;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.FilePath;
import hudson.Functions;
import hudson.model.Computer;
import hudson.model.Node;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.logging.Level;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

@Extension
public class NodeRemoteDirectoryComponent
extends DirectoryComponent<Computer>
implements Serializable {
    public NodeRemoteDirectoryComponent() {
    }

    @DataBoundConstructor
    public NodeRemoteDirectoryComponent(String includes, String excludes, boolean defaultExcludes, int maxDepth) {
        super(includes, excludes, defaultExcludes, maxDepth);
    }

    @Override
    public void addContents(@NonNull Container container, @NonNull Computer item) {
        Node node = item.getNode();
        if (node == null || item.isOffline()) {
            return;
        }
        FilePath rootPath = node.getRootPath();
        if (rootPath == null) {
            LOGGER.log(Level.WARNING, "Node " + node.getDisplayName() + " seems to be offline");
            return;
        }
        try {
            Arrays.stream(rootPath.list(this.getIncludes(), this.getExcludes(), this.getDefaultExcludes())).forEach(filePath -> {
                Path relativePath = Paths.get(rootPath.getRemote(), new String[0]).relativize(Paths.get(filePath.getRemote(), new String[0]));
                if (relativePath.getNameCount() <= this.getMaxDepth()) {
                    container.add(new FilePathContent("nodes/slave/{0}/remote/{1}", new String[]{node.getNodeName(), Functions.isWindows() ? relativePath.toString().replace('\\', '/') : relativePath.toString()}, (FilePath)filePath));
                }
            });
        }
        catch (IOException | InterruptedException e) {
            LOGGER.log(Level.WARNING, "Could not list files from remote directory of " + node.getNodeName(), e);
        }
    }

    @Override
    @NonNull
    public Component.ComponentCategory getCategory() {
        return Component.ComponentCategory.AGENT;
    }

    @Override
    @NonNull
    public String getDisplayName() {
        return Messages.NodeRemoteDirectoryComponent_DisplayName();
    }

    @Override
    public boolean isApplicable(Computer item) {
        return item != Jenkins.get().toComputer();
    }

    @Override
    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)Jenkins.get().getDescriptorByType(DescriptorImpl.class);
    }

    @Extension
    @Symbol(value={"nodeRemoteDirectoryComponent"})
    public static class DescriptorImpl
    extends DirectoryComponent.DirectoryComponentsDescriptor<Computer> {
        static final int DEFAULT_MAX_DEPTH = 10;

        public DescriptorImpl() {
            super("remoting/**, support/**", "remoting/jarCache/**", true, 10);
        }

        @Override
        @NonNull
        public String getDisplayName() {
            return Messages.NodeRemoteDirectoryComponent_DisplayName();
        }

        @Restricted(value={NoExternalUse.class})
        public FormValidation doCheckIncludes(@AncestorInPath Computer computer, @QueryParameter String includes) throws IOException {
            Node node = computer.getNode();
            if (node == null || computer.isOffline()) {
                return FormValidation.ok();
            }
            FilePath rootPath = node.getRootPath();
            if (rootPath == null) {
                return FormValidation.ok();
            }
            return FilePath.validateFileMask((FilePath)rootPath, (String)includes, (boolean)true);
        }

        @Restricted(value={NoExternalUse.class})
        public FormValidation doCheckExcludes(@AncestorInPath Computer computer, @QueryParameter String excludes) throws IOException {
            Node node = computer.getNode();
            if (node == null || computer.isOffline()) {
                return FormValidation.ok();
            }
            FilePath rootPath = node.getRootPath();
            if (rootPath == null) {
                return FormValidation.ok();
            }
            return FilePath.validateFileMask((FilePath)rootPath, (String)excludes, (boolean)true);
        }
    }
}

