/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support.impl;

import com.cloudbees.jenkins.support.filter.ContentFilter;
import com.cloudbees.jenkins.support.filter.PrefilteredContent;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.jenkins.lib.support_log_formatter.SupportLogFormatter;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public abstract class LogRecordContent
extends PrefilteredContent {
    private static final Formatter LOG_FORMATTER = new SupportLogFormatter();

    public LogRecordContent(String name) {
        super(name);
    }

    public LogRecordContent(String name, String ... filterableParameters) {
        super(name, filterableParameters);
    }

    public abstract Iterable<LogRecord> getLogRecords() throws IOException;

    @Override
    public final void writeTo(OutputStream os) throws IOException {
        this.writeTo(os, ContentFilter.NONE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void writeTo(OutputStream os, @NonNull ContentFilter filter) throws IOException {
        PrintWriter writer = this.getWriter(os);
        try {
            this.printTo(writer, filter);
        }
        finally {
            writer.flush();
        }
    }

    protected void printTo(PrintWriter out) throws IOException {
        this.printTo(out, ContentFilter.NONE);
    }

    protected void printTo(PrintWriter out, @NonNull ContentFilter filter) throws IOException {
        for (LogRecord logRecord : this.getLogRecords()) {
            String filtered = LOG_FORMATTER.format(logRecord);
            filtered = ContentFilter.filter(filter, filtered);
            out.print(filtered);
        }
        out.flush();
    }

    private PrintWriter getWriter(OutputStream os) {
        return new PrintWriter(new BufferedWriter(new OutputStreamWriter(os, StandardCharsets.UTF_8)));
    }
}

