/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support.impl;

import com.cloudbees.jenkins.support.api.ObjectComponent;
import com.cloudbees.jenkins.support.api.ObjectComponentDescriptor;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.ExtensionPoint;
import hudson.Util;
import hudson.model.AbstractModelObject;
import hudson.security.Permission;
import hudson.util.DirScanner;
import hudson.util.FileVisitor;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Stream;
import jenkins.model.Jenkins;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.QueryParameter;

public abstract class DirectoryComponent<T extends AbstractModelObject>
extends ObjectComponent<T>
implements ExtensionPoint {
    static final Logger LOGGER = Logger.getLogger(DirectoryComponent.class.getName());
    private String includes;
    private String excludes;
    private int maxDepth;
    private boolean defaultExcludes;

    public DirectoryComponent() {
        this.setExcludes(((DirectoryComponentsDescriptor)this.getDescriptor()).getExcludes());
        this.setIncludes(((DirectoryComponentsDescriptor)this.getDescriptor()).getIncludes());
        this.setDefaultExcludes(((DirectoryComponentsDescriptor)this.getDescriptor()).isDefaultExcludes());
        this.setMaxDepth(((DirectoryComponentsDescriptor)this.getDescriptor()).getMaxDepth());
    }

    public DirectoryComponent(String includes, String excludes, boolean defaultExcludes, int maxDepth) {
        this.setExcludes(excludes);
        this.setIncludes(includes);
        this.setDefaultExcludes(defaultExcludes);
        this.setMaxDepth(maxDepth);
    }

    protected final void list(File dir, final FileVisitor visitor) throws IOException {
        DirGlobScanner scan = new DirGlobScanner(this.getIncludes(), this.getExcludes(), this.getDefaultExcludes(), false);
        scan.scan(dir, new FileVisitor(){

            public void visit(File file, String s) throws IOException {
                if (Paths.get(s, new String[0]).getNameCount() <= DirectoryComponent.this.getMaxDepth()) {
                    visitor.visit(file, s);
                }
            }

            public void visitSymlink(File link, String target, String relativePath) throws IOException {
                if (Paths.get(relativePath, new String[0]).getNameCount() <= DirectoryComponent.this.getMaxDepth()) {
                    visitor.visitSymlink(link, target, relativePath);
                }
            }

            public boolean understandsSymlink() {
                return true;
            }
        });
    }

    public String getIncludes() {
        return this.includes;
    }

    public String getExcludes() {
        return this.excludes;
    }

    public boolean getDefaultExcludes() {
        return this.defaultExcludes;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public void setIncludes(String includes) {
        this.includes = includes;
    }

    public void setExcludes(String excludes) {
        this.excludes = excludes;
    }

    public void setDefaultExcludes(boolean defaultExcludes) {
        this.defaultExcludes = defaultExcludes;
    }

    public void setMaxDepth(int maxDepth) {
        this.maxDepth = maxDepth;
    }

    @Override
    public DirectoryComponentsDescriptor<T> getDescriptor() {
        return (DirectoryComponentsDescriptor)Jenkins.get().getDescriptorByType(DirectoryComponentsDescriptor.class);
    }

    @Override
    @NonNull
    public Set<Permission> getRequiredPermissions() {
        return Collections.singleton(Jenkins.ADMINISTER);
    }

    @Override
    @NonNull
    public String getDisplayName() {
        return "Files in Directory";
    }

    public static class DirectoryComponentsDescriptor<T extends AbstractModelObject>
    extends ObjectComponentDescriptor<T> {
        static final int DEFAULT_MAX_DEPTH = 10;
        private String includes;
        private String excludes;
        private boolean defaultExcludes;
        private int maxDepth;

        public DirectoryComponentsDescriptor() {
            this("", "", true, 10);
        }

        public DirectoryComponentsDescriptor(String includes, String excludes, boolean defaultExcludes, int maxDepth) {
            this.setIncludes(includes);
            this.setExcludes(excludes);
            this.setMaxDepth(maxDepth);
            this.setDefaultExcludes(defaultExcludes);
        }

        @NonNull
        public String getDisplayName() {
            return "Files in Directory";
        }

        public String getIncludes() {
            return this.includes;
        }

        public void setIncludes(String includes) {
            this.includes = includes;
        }

        public String getExcludes() {
            return this.excludes;
        }

        public void setExcludes(String excludes) {
            this.excludes = excludes;
        }

        public boolean isDefaultExcludes() {
            return this.defaultExcludes;
        }

        public void setDefaultExcludes(boolean defaultExcludes) {
            this.defaultExcludes = defaultExcludes;
        }

        public int getMaxDepth() {
            return this.maxDepth;
        }

        public void setMaxDepth(int maxDepth) {
            this.maxDepth = maxDepth;
        }

        @Restricted(value={NoExternalUse.class})
        public FormValidation doCheckMaxDepth(@QueryParameter String value) {
            return FormValidation.validatePositiveInteger((String)value);
        }
    }

    public static class DirGlobScanner
    extends DirScanner {
        private final String includes;
        private final String excludes;
        private boolean useDefaultExcludes;
        private boolean followSymlinks;
        private static final long serialVersionUID = 1L;

        public DirGlobScanner(String includes, String excludes, boolean useDefaultExcludes, boolean followSymlinks) {
            this.includes = includes;
            this.excludes = excludes;
            this.useDefaultExcludes = useDefaultExcludes;
            this.followSymlinks = followSymlinks;
        }

        public void scan(File dir, FileVisitor visitor) throws IOException {
            FileSet fileSet = Util.createFileSet((File)dir, (String)Optional.ofNullable(Util.fixEmpty((String)this.includes)).orElse("**/*"), (String)Optional.ofNullable(Util.fixEmpty((String)this.excludes)).orElse(""));
            fileSet.setDefaultexcludes(this.useDefaultExcludes);
            fileSet.setFollowSymlinks(this.followSymlinks);
            if (dir.exists()) {
                DirectoryScanner dirScanner = fileSet.getDirectoryScanner(new Project());
                ArrayList<String> var5 = new ArrayList<String>(Arrays.asList(dirScanner.getIncludedFiles()));
                var5.addAll(Stream.of(dirScanner.getNotFollowedSymlinks()).map(s -> dir.toPath().relativize(Paths.get(s, new String[0])).toString()).toList());
                for (String f : var5) {
                    File file = new File(dir, f);
                    this.scanSingle(file, f, visitor);
                }
            }
        }
    }
}

