/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support.impl;

import com.cloudbees.jenkins.support.api.Container;
import com.cloudbees.jenkins.support.api.FileContent;
import com.cloudbees.jenkins.support.api.PrintedContent;
import com.cloudbees.jenkins.support.impl.DirectoryComponent;
import com.cloudbees.jenkins.support.impl.Messages;
import com.cloudbees.jenkins.support.impl.RunDirectoryComponent;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Functions;
import hudson.model.AbstractItem;
import hudson.util.FileVisitor;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jenkins.model.Jenkins;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

@Extension
public class AbstractItemDirectoryComponent
extends DirectoryComponent<AbstractItem> {
    public AbstractItemDirectoryComponent() {
    }

    @DataBoundConstructor
    public AbstractItemDirectoryComponent(String includes, String excludes, boolean defaultExcludes, int maxDepth) {
        super(includes, excludes, defaultExcludes, maxDepth);
    }

    @Override
    public void addContents(final @NonNull Container container, @NonNull AbstractItem item) {
        try {
            File itemRootDir = item.getRootDir();
            final String relativeToRoot = Functions.isWindows() ? new File(Jenkins.get().getRootDir(), "jobs").toPath().relativize(itemRootDir.toPath()).toString().replace('\\', '/') : new File(Jenkins.get().getRootDir(), "jobs").toPath().relativize(itemRootDir.toPath()).toString();
            this.list(itemRootDir, new FileVisitor(){

                public void visitSymlink(File link, final String target, String relativePath) {
                    container.add(new PrintedContent("items/{0}/{1}", new String[]{relativeToRoot, Functions.isWindows() ? relativePath.replace('\\', '/') : relativePath}){

                        @Override
                        protected void printTo(PrintWriter out) {
                            out.println("symlink -> " + target);
                        }

                        @Override
                        public boolean shouldBeFiltered() {
                            return true;
                        }
                    });
                }

                public void visit(File file, String s) {
                    container.add(new FileContent("items/{0}/{1}", new String[]{relativeToRoot, Functions.isWindows() ? s.replace('\\', '/') : s}, file));
                }

                public boolean understandsSymlink() {
                    return true;
                }
            });
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Could not list files from root directory of " + item.getFullName(), e);
        }
    }

    @Override
    @NonNull
    public String getDisplayName() {
        return Messages.AbstractItemDirectoryComponent_DisplayName();
    }

    @Override
    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)Jenkins.get().getDescriptorByType(DescriptorImpl.class);
    }

    @Extension
    @Symbol(value={"abstractItemDirectoryComponent"})
    public static class DescriptorImpl
    extends DirectoryComponent.DirectoryComponentsDescriptor<AbstractItem> {
        static final int DEFAULT_MAX_DEPTH = 5;
        private static final List<String> EXCLUDES = List.of("**/jobs/", "**/branches/");

        public DescriptorImpl() {
            super("", Stream.concat(EXCLUDES.stream(), RunDirectoryComponent.DescriptorImpl.EXCLUDES.stream().map(p -> "builds/*/" + p)).collect(Collectors.joining(",")), true, 5);
        }

        @Override
        @NonNull
        public String getDisplayName() {
            return "Files in Item Root Directory";
        }

        @Restricted(value={NoExternalUse.class})
        public FormValidation doCheckIncludes(@AncestorInPath AbstractItem item, @QueryParameter String includes) {
            if (item == null) {
                return FormValidation.ok();
            }
            try {
                FileSet fs = new FileSet();
                fs.setDir(item.getRootDir());
                fs.setProject(new Project());
                fs.setIncludes(includes);
                return FormValidation.ok();
            }
            catch (Exception e) {
                return FormValidation.error((Throwable)e, (String)"Could not parse the patterns");
            }
        }

        @Restricted(value={NoExternalUse.class})
        public FormValidation doCheckExcludes(@AncestorInPath AbstractItem item, @QueryParameter String excludes) {
            if (item == null) {
                return FormValidation.ok();
            }
            try {
                FileSet fs = new FileSet();
                fs.setDir(item.getRootDir());
                fs.setProject(new Project());
                fs.setExcludes(excludes);
                return FormValidation.ok();
            }
            catch (Exception e) {
                return FormValidation.error((Throwable)e, (String)"Could not parse the patterns");
            }
        }
    }
}

