/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support.impl;

import com.cloudbees.jenkins.support.AsyncResultCache;
import com.cloudbees.jenkins.support.SupportPlugin;
import com.cloudbees.jenkins.support.api.Component;
import com.cloudbees.jenkins.support.api.Container;
import com.cloudbees.jenkins.support.api.PrefilteredPrintedContent;
import com.cloudbees.jenkins.support.api.PrintedContent;
import com.cloudbees.jenkins.support.api.SupportProvider;
import com.cloudbees.jenkins.support.filter.ContentFilter;
import com.cloudbees.jenkins.support.filter.ContentFilters;
import com.cloudbees.jenkins.support.filter.PasswordRedactor;
import com.cloudbees.jenkins.support.util.Markdown;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Snapshot;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.FilePath;
import hudson.PluginManager;
import hudson.PluginWrapper;
import hudson.Util;
import hudson.lifecycle.Lifecycle;
import hudson.model.Computer;
import hudson.model.Describable;
import hudson.model.Node;
import hudson.model.Slave;
import hudson.remoting.Channel;
import hudson.remoting.Launcher;
import hudson.remoting.VirtualChannel;
import hudson.security.Permission;
import hudson.util.IOUtils;
import jakarta.servlet.ServletContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryManagerMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.RuntimeMXBean;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import jenkins.model.JenkinsLocationConfiguration;
import jenkins.model.identity.IdentityRootAction;
import jenkins.security.MasterToSlaveCallable;
import jenkins.slaves.RemotingVersionInfo;
import org.apache.commons.io.FileUtils;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest2;

@Extension
public class AboutJenkins
extends Component {
    private static final Logger logger = Logger.getLogger(AboutJenkins.class.getName());
    private final WeakHashMap<Node, String> agentVersionCache = new WeakHashMap();
    private final WeakHashMap<Node, String> javaInfoCache = new WeakHashMap();
    private final WeakHashMap<Node, String> agentDigestCache = new WeakHashMap();

    @Override
    @NonNull
    public Set<Permission> getRequiredPermissions() {
        return Collections.singleton(Jenkins.ADMINISTER);
    }

    @Override
    @NonNull
    public String getDisplayName() {
        return "About Jenkins";
    }

    @Override
    @NonNull
    public Component.ComponentCategory getCategory() {
        return Component.ComponentCategory.CONTROLLER;
    }

    @Override
    public void addContents(@NonNull Container container) {
        ArrayList<PluginWrapper> activePlugins = new ArrayList<PluginWrapper>();
        ArrayList<PluginWrapper> disabledPlugins = new ArrayList<PluginWrapper>();
        ArrayList<PluginWrapper> backupPlugins = new ArrayList<PluginWrapper>();
        AboutJenkins.populatePluginsLists(activePlugins, disabledPlugins, backupPlugins);
        container.add(new AboutContent(activePlugins));
        container.add(new IdentityContent());
        container.add(new NodesContent());
        container.add(new ActivePlugins(activePlugins));
        container.add(new DisabledPlugins(disabledPlugins));
        container.add(new FailedPlugins());
        container.add(new BackupPlugins(backupPlugins));
        container.add(new Dockerfile(activePlugins, disabledPlugins));
        container.add(new ControllerChecksumsContent());
        for (Node node : Jenkins.get().getNodes()) {
            container.add(new NodeChecksumsContent(node));
        }
    }

    private static String getDescriptorName(@CheckForNull Describable<?> d) {
        if (d == null) {
            return "(none)";
        }
        return "`" + Markdown.escapeBacktick(d.getClass().getName()) + "`";
    }

    private void printHistogram(PrintWriter out, Histogram histogram) {
        out.println("      - Sample size:        " + histogram.getCount());
        Snapshot snapshot = histogram.getSnapshot();
        out.println("      - Average (mean):     " + snapshot.getMean());
        out.println("      - Average (median):   " + snapshot.getMedian());
        out.println("      - Standard deviation: " + snapshot.getStdDev());
        out.println("      - Minimum:            " + snapshot.getMin());
        out.println("      - Maximum:            " + snapshot.getMax());
        out.println("      - 95th percentile:    " + snapshot.get95thPercentile());
        out.println("      - 99th percentile:    " + snapshot.get99thPercentile());
    }

    private static String humanReadableSize(long size) {
        String measure = "B";
        if (size < 1024L) {
            return size + " " + measure;
        }
        double number = size;
        if (number >= 1024.0) {
            number /= 1024.0;
            measure = "KB";
            if (number >= 1024.0) {
                number /= 1024.0;
                measure = "MB";
                if (number >= 1024.0) {
                    number /= 1024.0;
                    measure = "GB";
                }
            }
        }
        DecimalFormat format = new DecimalFormat("#0.00");
        return format.format(number) + " " + measure + " (" + size + ")";
    }

    private static Iterable<PluginWrapper> getPluginsSorted() {
        PluginManager pluginManager = Jenkins.get().getPluginManager();
        return AboutJenkins.getPluginsSorted(pluginManager);
    }

    private static Iterable<PluginWrapper> getPluginsSorted(PluginManager pluginManager) {
        return AboutJenkins.listToSortedIterable(pluginManager.getPlugins());
    }

    private static <T extends Comparable<T>> Iterable<T> listToSortedIterable(List<T> list) {
        LinkedList<T> sorted = new LinkedList<T>(list);
        Collections.sort(sorted);
        return sorted;
    }

    private static void populatePluginsLists(List<PluginWrapper> activePlugins, List<PluginWrapper> disabledPlugins, List<PluginWrapper> backupPlugins) {
        for (PluginWrapper plugin : AboutJenkins.getPluginsSorted()) {
            if (plugin.isActive()) {
                activePlugins.add(plugin);
            } else {
                disabledPlugins.add(plugin);
            }
            if (plugin.getBackupVersion() == null) continue;
            backupPlugins.add(plugin);
        }
    }

    private static class AboutContent
    extends PrefilteredPrintedContent {
        private final Iterable<PluginWrapper> plugins;

        AboutContent(Iterable<PluginWrapper> plugins) {
            super("about.md");
            this.plugins = plugins;
        }

        @Override
        protected void printTo(PrintWriter out, ContentFilter filter) throws IOException {
            SupportProvider supportProvider;
            Jenkins jenkins = Jenkins.get();
            out.println("Jenkins");
            out.println("=======");
            out.println();
            out.println("Version details");
            out.println("---------------");
            out.println();
            out.println("  * Version: `" + Markdown.escapeBacktick(Jenkins.VERSION) + "`");
            out.println("  * Instance ID: `" + Markdown.escapeBacktick(Jenkins.get().getLegacyInstanceId()) + "`");
            File jenkinsWar = Lifecycle.get().getHudsonWar();
            if (jenkinsWar == null) {
                out.println("  * Mode:    Webapp Directory");
            } else {
                out.println("  * Mode:    WAR");
            }
            JenkinsLocationConfiguration jlc = JenkinsLocationConfiguration.get();
            out.println("  * Url:     " + ContentFilter.filter(filter, jlc.getUrl()));
            StaplerRequest2 request = Stapler.getCurrentRequest2();
            if (request != null) {
                ServletContext servletContext = request.getServletContext();
                out.println("  * Servlet container");
                out.println("      - Specification: " + servletContext.getMajorVersion() + "." + servletContext.getMinorVersion());
                out.println("      - Name:          `" + Markdown.escapeBacktick(servletContext.getServerInfo()) + "`");
            }
            out.print(new GetJavaInfo("  *", "      -").getInfo(filter));
            out.println();
            out.println("Remoting details");
            out.println("---------------");
            out.println();
            out.println("  * Embedded Version: `" + Markdown.escapeBacktick(RemotingVersionInfo.getEmbeddedVersion().toString()) + "`");
            out.println("  * Minimum Supported Version: `" + Markdown.escapeBacktick(RemotingVersionInfo.getMinimumSupportedVersion().toString()) + "`");
            out.println();
            out.println("Important configuration");
            out.println("---------------");
            out.println();
            out.println("  * Security realm: " + AboutJenkins.getDescriptorName(jenkins.getSecurityRealm()));
            out.println("  * Authorization strategy: " + AboutJenkins.getDescriptorName(jenkins.getAuthorizationStrategy()));
            out.println("  * CSRF Protection: " + jenkins.isUseCrumbs());
            out.println("  * Initialization Milestone: " + String.valueOf(jenkins.getInitLevel()));
            out.println("  * Support bundle anonymization: " + ContentFilters.get().isEnabled());
            out.println();
            out.println("Active Plugins");
            out.println("--------------");
            out.println();
            for (PluginWrapper w : this.plugins) {
                if (!w.isActive()) continue;
                out.println("  * " + w.getShortName() + ":" + w.getVersion() + (w.hasUpdate() ? " *(update available)*" : "") + " '" + w.getDisplayName() + "'");
            }
            SupportPlugin supportPlugin = SupportPlugin.getInstance();
            if (supportPlugin != null && (supportProvider = supportPlugin.getSupportProvider()) != null) {
                out.println();
                try {
                    supportProvider.printAboutJenkins(out);
                }
                catch (Throwable e) {
                    logger.log(Level.WARNING, null, e);
                }
            }
        }
    }

    private static class IdentityContent
    extends PrintedContent {
        IdentityContent() {
            super("identity.md");
        }

        @Override
        protected void printTo(PrintWriter out) throws IOException {
            IdentityRootAction idRootAction = (IdentityRootAction)ExtensionList.lookupSingleton(IdentityRootAction.class);
            out.println("Public Key");
            out.println("---------------");
            out.println(idRootAction.getPublicKey());
            out.println();
            out.println("Fingerprint");
            out.println("---------------");
            out.println(idRootAction.getFingerprint());
        }
    }

    private class NodesContent
    extends PrefilteredPrintedContent {
        NodesContent() {
            super("nodes.md");
        }

        private String getLabelString(Node n) {
            return Markdown.prettyNone(n.getLabelString());
        }

        @Override
        protected void printTo(PrintWriter out, ContentFilter filter) throws IOException {
            Jenkins jenkins = Jenkins.get();
            SupportPlugin supportPlugin = SupportPlugin.getInstance();
            if (supportPlugin != null) {
                out.println("Node statistics");
                out.println("===============");
                out.println();
                out.println("  * Total number of nodes");
                AboutJenkins.this.printHistogram(out, supportPlugin.getJenkinsNodeTotalCount());
                out.println("  * Total number of nodes online");
                AboutJenkins.this.printHistogram(out, supportPlugin.getJenkinsNodeOnlineCount());
                out.println("  * Total number of executors");
                AboutJenkins.this.printHistogram(out, supportPlugin.getJenkinsExecutorTotalCount());
                out.println("  * Total number of executors in use");
                AboutJenkins.this.printHistogram(out, supportPlugin.getJenkinsExecutorUsedCount());
                out.println();
            }
            out.println("Build Nodes");
            out.println("===========");
            out.println();
            out.println("  * master (Jenkins)");
            out.println("      - Description:    _" + Markdown.escapeUnderscore(Util.fixNull((String)ContentFilter.filter(filter, jenkins.getNodeDescription()))) + "_");
            out.println("      - Executors:      " + jenkins.getNumExecutors());
            out.println("      - FS root:        `" + Markdown.escapeBacktick(ContentFilter.filter(filter, jenkins.getRootDir().getAbsolutePath())) + "`");
            out.println("      - Labels:         " + ContentFilter.filter(filter, this.getLabelString((Node)jenkins)));
            out.println("      - Usage:          `" + String.valueOf(jenkins.getMode()) + "`");
            Optional.ofNullable(jenkins.toComputer()).ifPresent(computer -> out.println("      - Marked Offline: " + this.isTemporarilyOffline((Computer)computer)));
            if (jenkins.getChannel() == null) {
                out.println("      - Status:         offline");
            } else {
                out.println("      - Status:         on-line");
            }
            out.println("      - Slave Version:  " + Launcher.VERSION);
            out.print(new GetJavaInfo("      -", "          +").getInfo(filter));
            out.println();
            for (Node node : jenkins.getNodes()) {
                out.println("  * `" + Markdown.escapeBacktick(ContentFilter.filter(filter, node.getNodeName())) + "` (" + AboutJenkins.getDescriptorName(node) + ")");
                out.println("      - Description:    _" + Markdown.escapeUnderscore(Util.fixNull((String)ContentFilter.filter(filter, node.getNodeDescription()))) + "_");
                out.println("      - Executors:      " + node.getNumExecutors());
                FilePath rootPath = node.getRootPath();
                if (rootPath != null) {
                    out.println("      - Remote FS root: `" + Markdown.escapeBacktick(ContentFilter.filter(filter, rootPath.getRemote())) + "`");
                } else if (node instanceof Slave) {
                    out.println("      - Remote FS root: `" + Markdown.escapeBacktick(ContentFilter.filter(filter, ((Slave)Slave.class.cast(node)).getRemoteFS())) + "`");
                }
                out.println("      - Labels:         " + Markdown.escapeUnderscore(ContentFilter.filter(filter, this.getLabelString(node))));
                out.println("      - Usage:          `" + String.valueOf(node.getMode()) + "`");
                if (node instanceof Slave) {
                    Slave agent = (Slave)node;
                    out.println("      - Launch method:  " + AboutJenkins.getDescriptorName(agent.getLauncher()));
                    out.println("      - Availability:   " + AboutJenkins.getDescriptorName(agent.getRetentionStrategy()));
                }
                Optional.ofNullable(node.toComputer()).ifPresent(computer -> out.println("      - Marked Offline: " + this.isTemporarilyOffline((Computer)computer)));
                VirtualChannel channel = node.getChannel();
                if (channel == null) {
                    out.println("      - Status:         off-line");
                } else {
                    out.println("      - Status:         on-line");
                    try {
                        out.println("      - Version:        " + AsyncResultCache.get(node, AboutJenkins.this.agentVersionCache, new GetAgentVersion(), "agent.jar version", "(timeout with no cache available)"));
                    }
                    catch (IOException e) {
                        logger.log(Level.WARNING, "Could not get agent.jar version for " + node.getNodeName(), e);
                    }
                    try {
                        String javaInfo = AsyncResultCache.get(node, AboutJenkins.this.javaInfoCache, new GetJavaInfo("      -", "          +"), "Java info");
                        if (javaInfo == null) {
                            logger.log(Level.FINE, "Could not get Java info for {0} and no cached value available", node.getNodeName());
                        } else {
                            out.print(ContentFilter.filter(filter, javaInfo));
                        }
                    }
                    catch (IOException e) {
                        logger.log(Level.WARNING, "Could not get Java info for " + node.getNodeName(), e);
                    }
                }
                out.println();
            }
        }

        private boolean isTemporarilyOffline(Computer computer) {
            return computer.isTemporarilyOffline();
        }
    }

    private static class ActivePlugins
    extends Plugins {
        ActivePlugins(Iterable<PluginWrapper> plugins) {
            super(plugins, "plugins/active.txt", (? super PluginWrapper w) -> w.getShortName() + ":" + w.getVersion());
        }
    }

    private static class DisabledPlugins
    extends Plugins {
        DisabledPlugins(Iterable<PluginWrapper> plugins) {
            super(plugins, "plugins/disabled.txt", (? super PluginWrapper w) -> w.getShortName() + ":" + w.getVersion());
        }
    }

    private static class FailedPlugins
    extends PrintedContent {
        FailedPlugins() {
            super("plugins/failed.txt");
        }

        @Override
        protected void printTo(PrintWriter out) throws IOException {
            PluginManager pluginManager = Jenkins.get().getPluginManager();
            List plugins = pluginManager.getFailedPlugins();
            for (PluginManager.FailedPlugin w : plugins) {
                out.println(w.name + " -> " + String.valueOf(w.cause));
            }
        }

        @Override
        public boolean shouldBeFiltered() {
            return false;
        }
    }

    private static class BackupPlugins
    extends Plugins {
        BackupPlugins(Iterable<PluginWrapper> plugins) {
            super(plugins, "plugins/backup.txt", (? super PluginWrapper w) -> w.getShortName() + ":" + w.getBackupVersion());
        }
    }

    private static class Dockerfile
    extends PrintedContent {
        private final List<PluginWrapper> activated;
        private final List<PluginWrapper> disabled;

        Dockerfile(List<PluginWrapper> activated, List<PluginWrapper> disabled) {
            super("docker/Dockerfile");
            this.activated = activated;
            this.disabled = disabled;
        }

        @Override
        protected void printTo(PrintWriter out) throws IOException {
            PluginManager pluginManager = Jenkins.get().getPluginManager();
            String fullVersion = Jenkins.VERSION;
            int s = fullVersion.indexOf(32);
            if (s > 0 && fullVersion.contains("CloudBees")) {
                out.println("FROM cloudbees/jenkins:" + fullVersion.substring(0, s));
            } else {
                out.println("FROM jenkins:" + fullVersion);
            }
            if (pluginManager.getPlugin("nectar-license") != null) {
                out.println("ENV JENKINS_UC http://jenkins-updates.cloudbees.com");
            }
            out.println("RUN mkdir -p /usr/share/jenkins/ref/plugins/");
            out.println("RUN curl \\");
            Iterator<PluginWrapper> activatedIT = this.activated.iterator();
            while (activatedIT.hasNext()) {
                PluginWrapper w = activatedIT.next();
                out.print("\t-L $JENKINS_UC/download/plugins/" + w.getShortName() + "/" + w.getVersion() + "/" + w.getShortName() + ".hpi -o /usr/share/jenkins/ref/plugins/" + w.getShortName() + ".jpi");
                if (!activatedIT.hasNext()) continue;
                out.println(" \\");
            }
            out.println();
            if (!this.disabled.isEmpty()) {
                out.println("RUN touch \\");
                Iterator<PluginWrapper> disabledIT = this.disabled.iterator();
                while (disabledIT.hasNext()) {
                    PluginWrapper w = disabledIT.next();
                    out.print("\n\t/usr/share/jenkins/ref/plugins/" + w.getShortName() + ".jpi.disabled");
                    if (!disabledIT.hasNext()) continue;
                    out.println(" \\");
                }
                out.println();
            }
            out.println();
        }

        @Override
        public boolean shouldBeFiltered() {
            return false;
        }
    }

    private static class ControllerChecksumsContent
    extends PrintedContent {
        ControllerChecksumsContent() {
            super("nodes/master/checksums.md5");
        }

        @Override
        protected void printTo(PrintWriter out) throws IOException {
            StaplerRequest2 request;
            Jenkins jenkins = Jenkins.get();
            if (jenkins == null) {
                throw new IOException("Jenkins has not been started, or was already shut down");
            }
            File jenkinsWar = Lifecycle.get().getHudsonWar();
            if (jenkinsWar != null) {
                try {
                    out.println(Util.getDigestOf((InputStream)new FileInputStream(jenkinsWar)) + "  jenkins.war");
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "Could not compute MD5 of jenkins.war", e);
                }
            }
            if ((request = Stapler.getCurrentRequest2()) != null) {
                ServletContext servletContext = request.getServletContext();
                Set resourcePaths = servletContext.getResourcePaths("/WEB-INF/lib");
                for (String resourcePath : new TreeSet(resourcePaths)) {
                    try {
                        out.println(Util.getDigestOf((InputStream)servletContext.getResourceAsStream(resourcePath)) + "  war" + resourcePath);
                    }
                    catch (IOException e) {
                        logger.log(Level.WARNING, "Could not compute MD5 of war" + resourcePath, e);
                    }
                }
                for (String resourcePath : Arrays.asList("/WEB-INF/jenkins-cli.jar", "/WEB-INF/web.xml")) {
                    try {
                        InputStream resourceAsStream = servletContext.getResourceAsStream(resourcePath);
                        if (resourceAsStream == null) continue;
                        out.println(Util.getDigestOf((InputStream)resourceAsStream) + "  war" + resourcePath);
                    }
                    catch (IOException e) {
                        logger.log(Level.WARNING, "Could not compute MD5 of war" + resourcePath, e);
                    }
                }
                resourcePaths = servletContext.getResourcePaths("/WEB-INF/update-center-rootCAs");
                for (String resourcePath : new TreeSet(resourcePaths)) {
                    try {
                        out.println(Util.getDigestOf((InputStream)servletContext.getResourceAsStream(resourcePath)) + "  war" + resourcePath);
                    }
                    catch (IOException e) {
                        logger.log(Level.WARNING, "Could not compute MD5 of war" + resourcePath, e);
                    }
                }
            }
            Collection pluginFiles = FileUtils.listFiles((File)new File(jenkins.getRootDir(), "plugins"), null, (boolean)false);
            for (File file : pluginFiles) {
                if (!file.isFile()) continue;
                try {
                    out.println(Util.getDigestOf((InputStream)new FileInputStream(file)) + "  plugins/" + file.getName());
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "Could not compute MD5 of war/" + String.valueOf(file), e);
                }
            }
        }

        @Override
        public boolean shouldBeFiltered() {
            return false;
        }
    }

    private class NodeChecksumsContent
    extends PrintedContent {
        private final Node node;

        NodeChecksumsContent(Node node) {
            super("nodes/slave/{0}/checksums.md5", node.getNodeName());
            this.node = node;
        }

        @Override
        protected void printTo(PrintWriter out) throws IOException {
            try {
                FilePath rootPath = this.node.getRootPath();
                String agentDigest = rootPath == null ? "N/A" : AsyncResultCache.get(this.node, AboutJenkins.this.agentDigestCache, new GetAgentDigest(rootPath), "checksums", "N/A");
                out.println(agentDigest);
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Could not compute checksums on agent " + this.node.getNodeName(), e);
            }
        }

        @Override
        public boolean shouldBeFiltered() {
            return false;
        }
    }

    private static class Plugins
    extends PrintedContent {
        private final Iterable<PluginWrapper> plugins;
        private final Function<? super PluginWrapper, String> stringify;

        Plugins(Iterable<PluginWrapper> plugins, String name, Function<? super PluginWrapper, String> stringify) {
            super(name);
            this.plugins = plugins;
            this.stringify = stringify;
        }

        @Override
        protected void printTo(PrintWriter out) throws IOException {
            this.plugins.forEach(w -> out.println(this.stringify.apply((PluginWrapper)w)));
        }

        @Override
        public boolean shouldBeFiltered() {
            return false;
        }
    }

    private static class GetJavaInfo
    extends MasterToSlaveCallable<String, RuntimeException> {
        private static final long serialVersionUID = 1L;
        private final String maj;
        private final String min;
        private final PasswordRedactor passwordRedactor;

        private GetJavaInfo(String majorBullet, String minorBullet) {
            this.maj = majorBullet;
            this.min = minorBullet;
            this.passwordRedactor = PasswordRedactor.get();
        }

        public String call() throws RuntimeException {
            return this.getInfo(null);
        }

        @SuppressFBWarnings(value={"DMI_HARDCODED_ABSOLUTE_FILENAME"})
        private String getInfo(@CheckForNull ContentFilter filter) {
            StringBuilder result = new StringBuilder();
            Runtime runtime = Runtime.getRuntime();
            result.append(this.maj).append(" Java\n");
            result.append(this.min).append(" Home:           `").append(Markdown.escapeBacktick(System.getProperty("java.home"))).append("`\n");
            result.append(this.min).append(" Vendor:           ").append(Markdown.escapeUnderscore(System.getProperty("java.vendor"))).append("\n");
            result.append(this.min).append(" Version:          ").append(Markdown.escapeUnderscore(System.getProperty("java.version"))).append("\n");
            long maxMem = runtime.maxMemory();
            long allocMem = runtime.totalMemory();
            long freeMem = runtime.freeMemory();
            result.append(this.min).append(" Maximum memory:   ").append(AboutJenkins.humanReadableSize(maxMem)).append("\n");
            result.append(this.min).append(" Allocated memory: ").append(AboutJenkins.humanReadableSize(allocMem)).append("\n");
            result.append(this.min).append(" Free memory:      ").append(AboutJenkins.humanReadableSize(freeMem)).append("\n");
            result.append(this.min).append(" In-use memory:    ").append(AboutJenkins.humanReadableSize(allocMem - freeMem)).append("\n");
            for (MemoryPoolMXBean memoryPoolMXBean : ManagementFactory.getMemoryPoolMXBeans()) {
                if (!memoryPoolMXBean.getName().toLowerCase().contains("perm gen")) continue;
                MemoryUsage currentUsage = memoryPoolMXBean.getUsage();
                result.append(this.min).append(" PermGen used:     ").append(AboutJenkins.humanReadableSize(currentUsage.getUsed())).append("\n");
                result.append(this.min).append(" PermGen max:      ").append(AboutJenkins.humanReadableSize(currentUsage.getMax())).append("\n");
                break;
            }
            for (MemoryManagerMXBean memoryManagerMXBean : ManagementFactory.getMemoryManagerMXBeans()) {
                if (memoryManagerMXBean.getName().contains("MarkSweepCompact")) {
                    result.append(this.min).append(" GC strategy:      SerialGC\n");
                    break;
                }
                if (memoryManagerMXBean.getName().contains("ConcurrentMarkSweep")) {
                    result.append(this.min).append(" GC strategy:      ConcMarkSweepGC\n");
                    break;
                }
                if (memoryManagerMXBean.getName().contains("PS")) {
                    result.append(this.min).append(" GC strategy:      ParallelGC\n");
                    break;
                }
                if (!memoryManagerMXBean.getName().contains("G1")) continue;
                result.append(this.min).append(" GC strategy:      G1\n");
                break;
            }
            result.append(this.min).append(" Available CPUs:   ").append(runtime.availableProcessors()).append("\n");
            result.append(this.maj).append(" Java Runtime Specification\n");
            result.append(this.min).append(" Name:    ").append(System.getProperty("java.specification.name")).append("\n");
            result.append(this.min).append(" Vendor:  ").append(System.getProperty("java.specification.vendor")).append("\n");
            result.append(this.min).append(" Version: ").append(System.getProperty("java.specification.version")).append("\n");
            result.append(this.maj).append(" JVM Specification\n");
            result.append(this.min).append(" Name:    ").append(System.getProperty("java.vm.specification.name")).append("\n");
            result.append(this.min).append(" Vendor:  ").append(System.getProperty("java.vm.specification.vendor")).append("\n");
            result.append(this.min).append(" Version: ").append(System.getProperty("java.vm.specification.version")).append("\n");
            result.append(this.maj).append(" JVM Implementation\n");
            result.append(this.min).append(" Name:    ").append(Markdown.escapeUnderscore(System.getProperty("java.vm.name"))).append("\n");
            result.append(this.min).append(" Vendor:  ").append(Markdown.escapeUnderscore(System.getProperty("java.vm.vendor"))).append("\n");
            result.append(this.min).append(" Version: ").append(Markdown.escapeUnderscore(System.getProperty("java.vm.version"))).append("\n");
            result.append(this.maj).append(" Operating system\n");
            result.append(this.min).append(" Name:         ").append(Markdown.escapeUnderscore(System.getProperty("os.name"))).append("\n");
            result.append(this.min).append(" Architecture: ").append(Markdown.escapeUnderscore(System.getProperty("os.arch"))).append("\n");
            result.append(this.min).append(" Version:      ").append(Markdown.escapeUnderscore(System.getProperty("os.version"))).append("\n");
            File lsb_release = new File("/usr/bin/lsb_release");
            if (lsb_release.canExecute()) {
                try {
                    Process process = new ProcessBuilder(new String[0]).command(lsb_release.getAbsolutePath(), "--description", "--short").start();
                    String distro = IOUtils.readFirstLine((InputStream)process.getInputStream(), (String)"UTF-8");
                    if (process.waitFor() == 0) {
                        result.append(this.min).append(" Distribution: ").append(Markdown.escapeUnderscore(distro)).append("\n");
                    } else {
                        logger.fine("lsb_release had a nonzero exit status");
                    }
                    Process process2 = new ProcessBuilder(new String[0]).command(lsb_release.getAbsolutePath(), "--version", "--short").start();
                    String modules = IOUtils.readFirstLine((InputStream)process2.getInputStream(), (String)"UTF-8");
                    if (process2.waitFor() == 0 && modules != null) {
                        result.append(this.min).append(" LSB Modules:  `").append(Markdown.escapeUnderscore(modules)).append("`\n");
                    } else {
                        logger.fine("lsb_release had a nonzero exit status");
                    }
                }
                catch (IOException iOException) {
                    logger.log(Level.WARNING, "lsb_release exists but could not run it", iOException);
                }
                catch (InterruptedException interruptedException) {
                    logger.log(Level.WARNING, "lsb_release hung", interruptedException);
                }
            }
            RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
            String process = runtimeMXBean.getName();
            Matcher processMatcher = Pattern.compile("^(-?[0-9]+)@.*$").matcher(process);
            if (processMatcher.matches()) {
                int processId = Integer.parseInt(processMatcher.group(1));
                result.append(this.maj).append(" Process ID: ").append(processId).append(" (0x").append(Integer.toHexString(processId)).append(")\n");
            }
            SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSZ");
            f.setTimeZone(TimeZone.getTimeZone("UTC"));
            result.append(this.maj).append(" Process started: ").append(f.format(new Date(runtimeMXBean.getStartTime()))).append('\n');
            result.append(this.maj).append(" Process uptime: ").append(Util.getTimeSpanString((long)runtimeMXBean.getUptime())).append('\n');
            result.append(this.maj).append(" JVM startup parameters:\n");
            if (runtimeMXBean.isBootClassPathSupported()) {
                result.append(this.min).append(" Boot classpath: `").append(Markdown.escapeBacktick(runtimeMXBean.getBootClassPath())).append("`\n");
            }
            result.append(this.min).append(" Classpath: `").append(Markdown.escapeBacktick(runtimeMXBean.getClassPath())).append("`\n");
            result.append(this.min).append(" Library path: `").append(Markdown.escapeBacktick(runtimeMXBean.getLibraryPath())).append("`\n");
            int count = 0;
            for (String arg : runtimeMXBean.getInputArguments()) {
                arg = this.passwordRedactor.redact(arg);
                result.append(this.min).append(" arg[").append(count++).append("]: `").append(Markdown.escapeBacktick(filter != null ? ContentFilter.filter(filter, arg) : arg)).append("`\n");
            }
            return result.toString();
        }
    }

    private static class GetAgentVersion
    extends MasterToSlaveCallable<String, RuntimeException> {
        private static final long serialVersionUID = 1L;

        private GetAgentVersion() {
        }

        /*
         * Enabled aggressive exception aggregation
         */
        public String call() throws RuntimeException {
            try (InputStream is = Channel.class.getResourceAsStream("/jenkins/remoting/jenkins-version.properties");){
                if (is == null) {
                    String string2 = "N/A";
                    return string2;
                }
                Properties properties = new Properties();
                try {
                    properties.load(is);
                    String string = properties.getProperty("version", "N/A");
                    return string;
                }
                catch (IOException e) {
                    String string3;
                    block13: {
                        string3 = "N/A";
                        if (is == null) break block13;
                        is.close();
                    }
                    return string3;
                }
            }
            catch (IOException e2) {
                logger.fine(String.format("Could not find remoting version in agent {}", e2.getMessage()));
                return "N/A";
            }
        }
    }

    private static final class GetAgentDigest
    extends MasterToSlaveCallable<String, RuntimeException> {
        private static final long serialVersionUID = 1L;
        private final String rootPathName;

        GetAgentDigest(FilePath rootPath) {
            this.rootPathName = rootPath.getRemote();
        }

        public String call() {
            StringBuilder result = new StringBuilder();
            File rootPath = new File(this.rootPathName);
            for (File file : FileUtils.listFiles((File)rootPath, null, (boolean)false)) {
                if (!file.isFile()) continue;
                try {
                    result.append(Util.getDigestOf((InputStream)new FileInputStream(file))).append("  ").append(file.getName()).append('\n');
                }
                catch (IOException iOException) {}
            }
            return result.toString();
        }
    }
}

