/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support.filter;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.function.Function;

public class FilteredInputStream
extends InputStream {
    private final Function<String, String> filter;
    private final Charset encoding;
    private final BufferedReader reader;
    private ByteArrayInputStream buffer;

    public FilteredInputStream(@NonNull InputStream is, @NonNull Charset encoding, @NonNull Function<String, String> filter) {
        this.encoding = encoding;
        this.reader = new BufferedReader(new InputStreamReader(is, encoding));
        this.filter = filter;
    }

    @Override
    public int read() throws IOException {
        int ch;
        if (this.buffer == null) {
            Object line = this.reader.readLine();
            if (line != null) {
                line = this.filter.apply((String)line);
                line = (String)line + System.lineSeparator();
                this.buffer = new ByteArrayInputStream(((String)line).getBytes(this.encoding));
            } else {
                return -1;
            }
        }
        if ((ch = this.buffer.read()) != -1) {
            return ch;
        }
        this.buffer = null;
        return this.read();
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

