/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support.filter;

import com.cloudbees.jenkins.support.filter.ContentMapping;
import com.cloudbees.jenkins.support.filter.DefaultStopWords;
import com.cloudbees.jenkins.support.filter.Messages;
import com.cloudbees.jenkins.support.filter.StopWords;
import com.cloudbees.jenkins.support.util.Persistence;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.AbstractItem;
import hudson.model.ManagementLink;
import hudson.model.Saveable;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Spliterator;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class ContentMappings
extends ManagementLink
implements Saveable,
Iterable<ContentMapping> {
    private static final Comparator<String> BY_LENGTH = Comparator.comparingLong(String::length);
    private static final Comparator<String> BY_NAME = Comparator.comparing(Function.identity());
    private static final Comparator<String> COMPARATOR = BY_LENGTH.reversed().thenComparing(BY_NAME);
    private static final Logger LOGGER = Logger.getLogger(ContentMappings.class.getName());
    private final Set<String> stopWords;
    private final Map<String, ContentMapping> mappings;

    public static ContentMappings get() {
        return (ContentMappings)ExtensionList.lookupSingleton(ContentMappings.class);
    }

    @Extension
    public static ContentMappings newInstance() throws IOException {
        ContentMappings mappings = Persistence.load(ContentMappings.class);
        if (mappings == null) {
            mappings = (ContentMappings)new XmlProxy().readResolve();
        }
        return mappings;
    }

    private ContentMappings(@NonNull XmlProxy proxy) {
        this.stopWords = proxy.stopWords != null ? proxy.stopWords : new HashSet<String>();
        this.stopWords.addAll(StopWords.all().stream().map(StopWords::getWords).flatMap(Collection::stream).collect(Collectors.toSet()));
        this.mappings = proxy.mappings == null ? new ConcurrentSkipListMap<String, ContentMapping>(COMPARATOR) : (Map)proxy.mappings.stream().filter(mapping -> !this.stopWords.contains(mapping.getOriginal().toLowerCase(Locale.ENGLISH))).collect(Collectors.toConcurrentMap(ContentMapping::getOriginal, Function.identity(), (a, b) -> {
            throw new IllegalArgumentException();
        }, () -> new ConcurrentSkipListMap(COMPARATOR)));
    }

    @NonNull
    public Set<String> getStopWords() {
        return Collections.unmodifiableSet(this.stopWords);
    }

    @NonNull
    public Map<String, String> getMappings() {
        return this.mappings.values().stream().collect(Collectors.toMap(ContentMapping::getOriginal, ContentMapping::getReplacement));
    }

    @NonNull
    public ContentMapping getMappingOrCreate(@NonNull String original, @NonNull Function<String, ContentMapping> generator) {
        boolean isNew = !this.mappings.containsKey(original);
        ContentMapping mapping = this.mappings.computeIfAbsent(original, generator);
        try {
            if (isNew) {
                this.save();
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Could not save mappings file", e);
        }
        return mapping;
    }

    public void reload() {
        Jenkins.get().allItems(AbstractItem.class).forEach((? super T item) -> {
            this.stopWords.add(item.getTaskNoun().toLowerCase(Locale.ENGLISH));
            this.stopWords.add(item.getPronoun().toLowerCase(Locale.ENGLISH));
        });
    }

    protected void clear() {
        this.stopWords.clear();
        this.stopWords.addAll(((DefaultStopWords)ExtensionList.lookupSingleton(DefaultStopWords.class)).getWords());
        this.mappings.clear();
    }

    public void save() throws IOException {
        Persistence.save(this);
    }

    @Override
    @NonNull
    public Iterator<ContentMapping> iterator() {
        return this.mappings.values().iterator();
    }

    @Override
    public void forEach(Consumer<? super ContentMapping> action) {
        this.mappings.values().forEach(action);
    }

    @Override
    public Spliterator<ContentMapping> spliterator() {
        return this.mappings.values().spliterator();
    }

    private Object writeReplace() {
        XmlProxy proxy = new XmlProxy();
        proxy.stopWords = new HashSet<String>(this.stopWords);
        proxy.stopWords.remove(Jenkins.VERSION);
        proxy.mappings = new HashSet<ContentMapping>(this.mappings.values());
        return proxy;
    }

    @NonNull
    public String getIconFileName() {
        return "symbol-support plugin-support-core";
    }

    @NonNull
    public String getDisplayName() {
        return Messages.ContentMappings_DisplayName();
    }

    public String getDescription() {
        return Messages.ContentMappings_Description();
    }

    @NonNull
    public String getUrlName() {
        return "anonymizedMappings";
    }

    @NonNull
    public ManagementLink.Category getCategory() {
        return ManagementLink.Category.SECURITY;
    }

    private static class XmlProxy {
        private Set<String> stopWords;
        private Set<ContentMapping> mappings;

        private XmlProxy() {
        }

        private Object readResolve() {
            return new ContentMappings(this);
        }
    }
}

