/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support.configfiles;

import com.cloudbees.jenkins.support.api.Component;
import com.cloudbees.jenkins.support.api.Container;
import com.cloudbees.jenkins.support.configfiles.XmlRedactedSecretFileContent;
import com.cloudbees.jenkins.support.filter.ContentMappings;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.security.Permission;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;

@Extension
public class OtherConfigFilesComponent
extends Component {
    private static final Logger LOGGER = Logger.getLogger(OtherConfigFilesComponent.class.getName());

    @Override
    @NonNull
    public Set<Permission> getRequiredPermissions() {
        return Collections.singleton(Jenkins.ADMINISTER);
    }

    @Override
    @NonNull
    public String getDisplayName() {
        return "Other Jenkins Configuration Files (Encrypted secrets are redacted)";
    }

    @Override
    public void addContents(@NonNull Container container) {
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        if (jenkins != null) {
            File dir = jenkins.getRootDir();
            File[] files = dir.listFiles(pathname -> ConfigFilesFilter.all().stream().allMatch(configFilesFilter -> configFilesFilter.include(pathname)));
            if (files != null) {
                for (File configFile : files) {
                    if (!configFile.exists()) continue;
                    container.add(new XmlRedactedSecretFileContent("jenkins-root-configuration-files/{0}", new String[]{configFile.getName()}, configFile));
                }
            } else {
                LOGGER.log(Level.WARNING, "Cannot list files in Jenkins root, probably something is wrong with the path");
            }
        }
    }

    @Override
    public boolean isSelectedByDefault() {
        return false;
    }

    @Override
    @NonNull
    public Component.ComponentCategory getCategory() {
        return Component.ComponentCategory.CONTROLLER;
    }

    public static interface ConfigFilesFilter
    extends ExtensionPoint {
        public static ExtensionList<ConfigFilesFilter> all() {
            return ExtensionList.lookup(ConfigFilesFilter.class);
        }

        public boolean include(@NonNull File var1);
    }

    @Extension
    public static class DefaultConfigFilesFilter
    implements ConfigFilesFilter {
        private static final List<String> BLACKLISTED_FILENAMES = List.of(ContentMappings.class.getName() + ".xml", "credentials.xml", "config.xml");

        @Override
        public boolean include(@NonNull File f) {
            return f.getName().toLowerCase().endsWith(".xml") && !BLACKLISTED_FILENAMES.contains(f.getName());
        }
    }
}

