/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support.configfiles;

import com.cloudbees.jenkins.support.api.Component;
import com.cloudbees.jenkins.support.api.Container;
import com.cloudbees.jenkins.support.api.ObjectComponent;
import com.cloudbees.jenkins.support.api.ObjectComponentDescriptor;
import com.cloudbees.jenkins.support.configfiles.XmlRedactedSecretFileContent;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.AbstractModelObject;
import hudson.model.Computer;
import hudson.model.Node;
import hudson.security.Permission;
import java.io.File;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Set;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

@Extension
public class AgentsConfigFile
extends ObjectComponent<Computer> {
    @DataBoundConstructor
    public AgentsConfigFile() {
    }

    @Override
    public boolean isSelectedByDefault() {
        return false;
    }

    @Override
    public boolean isSelectedByDefault(Computer item) {
        return true;
    }

    @Override
    @NonNull
    public Set<Permission> getRequiredPermissions() {
        return Collections.singleton(Jenkins.ADMINISTER);
    }

    @Override
    @NonNull
    public Component.ComponentCategory getCategory() {
        return Component.ComponentCategory.AGENT;
    }

    @Override
    @NonNull
    public String getDisplayName() {
        return "Agent Configuration File";
    }

    @Override
    public void addContents(@NonNull Container container) {
        for (Node n : Jenkins.get().getNodes()) {
            Computer c = n.toComputer();
            if (c == null) continue;
            this.addContents(container, c);
        }
    }

    @Override
    public void addContents(@NonNull Container container, Computer item) {
        if (item.getNode() == null) {
            return;
        }
        File agentDir = new File(Jenkins.get().getRootDir(), MessageFormat.format("nodes/{0}", item.getName()));
        File config = new File(agentDir, "config.xml");
        container.add(new XmlRedactedSecretFileContent("nodes/slave/{0}/config.xml", new String[]{agentDir.getName()}, config));
    }

    @Override
    public <C extends AbstractModelObject> boolean isApplicable(Class<C> clazz) {
        return Jenkins.class.isAssignableFrom(clazz) || Computer.class.isAssignableFrom(clazz);
    }

    @Override
    public boolean isApplicable(Computer item) {
        return !(item instanceof Jenkins.MasterComputer);
    }

    @Override
    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)Jenkins.get().getDescriptorByType(DescriptorImpl.class);
    }

    @Extension
    @Symbol(value={"agentsConfigFileComponent"})
    public static class DescriptorImpl
    extends ObjectComponentDescriptor<Computer> {
        @NonNull
        public String getDisplayName() {
            return "Agent Configuration File";
        }
    }
}

