/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support.config;

import com.cloudbees.jenkins.support.SupportAction;
import com.cloudbees.jenkins.support.SupportPlugin;
import com.cloudbees.jenkins.support.api.Component;
import com.cloudbees.jenkins.support.config.Messages;
import com.cloudbees.jenkins.support.config.SupportPluginConfigurationCategory;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.BulkChange;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.Descriptor;
import hudson.model.Saveable;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.model.GlobalConfiguration;
import jenkins.model.GlobalConfigurationCategory;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.verb.POST;

@Extension
@Restricted(value={NoExternalUse.class})
@Symbol(value={"automatedBundleConfiguration"})
public class SupportAutomatedBundleConfiguration
extends GlobalConfiguration {
    private static final Logger LOG = Logger.getLogger(SupportAutomatedBundleConfiguration.class.getName());
    private List<String> componentIds;
    private boolean enabled = true;
    private int period = 1;

    @NonNull
    public static SupportAutomatedBundleConfiguration get() {
        return (SupportAutomatedBundleConfiguration)((Object)ExtensionList.lookupSingleton(SupportAutomatedBundleConfiguration.class));
    }

    public SupportAutomatedBundleConfiguration() {
        this.load();
    }

    public List<String> getComponentIds() {
        return this.componentIds == null ? SupportAutomatedBundleConfiguration.getDefaultComponentIds() : this.componentIds;
    }

    public static List<String> getDefaultComponentIds() {
        return SupportAutomatedBundleConfiguration.getApplicableComponents().stream().filter(Component::isEnabled).map(Component::getId).collect(Collectors.toList());
    }

    public boolean isEnabled() {
        return !this.isEnforcedDisabled() && (this.isEnforcedPeriod() || this.enabled);
    }

    public int getPeriod() {
        return this.isEnforcedDisabled() ? 0 : Math.max(Math.min(24, this.isEnforcedPeriod() ? SupportPlugin.AUTO_BUNDLE_PERIOD_HOURS : this.period), 1);
    }

    public boolean isEnforcedPeriod() {
        return System.getProperty(SupportPlugin.class.getName() + ".AUTO_BUNDLE_PERIOD_HOURS") != null;
    }

    @DataBoundSetter
    public void setComponentIds(List<String> componentIds) {
        this.componentIds = componentIds;
    }

    @DataBoundSetter
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnforcedDisabled() {
        return SupportPlugin.AUTO_BUNDLE_PERIOD_HOURS == 0;
    }

    @DataBoundSetter
    public void setPeriod(Integer period) {
        this.period = Math.max(Math.min(24, period), 1);
    }

    @NonNull
    public String getDisplayName() {
        return Messages.SupportAutomatedBundleConfiguration_displayName();
    }

    public List<Component> getComponents() {
        return this.componentIds == null ? SupportAutomatedBundleConfiguration.getApplicableComponents().stream().filter(component -> SupportAutomatedBundleConfiguration.getDefaultComponentIds().contains(component.getId())).collect(Collectors.toList()) : SupportAutomatedBundleConfiguration.getApplicableComponents().stream().filter(component -> this.componentIds.contains(component.getId())).collect(Collectors.toList());
    }

    public boolean isComponentSelected(Component component) {
        return this.componentIds == null || this.componentIds.stream().anyMatch(c -> c.equals(component.getId()));
    }

    public static List<Component> getApplicableComponents() {
        return SupportPlugin.getComponents();
    }

    @POST
    public boolean configure(StaplerRequest2 req, JSONObject json) throws Descriptor.FormException {
        boolean isEnabled;
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        if (this.isEnforcedDisabled()) {
            return true;
        }
        boolean bl = isEnabled = this.isEnforcedPeriod() || json.getBoolean("enabled");
        if (isEnabled && !json.has("components")) {
            throw new Descriptor.FormException(Messages.SupportAutomatedBundleConfiguration_enabled_noComponents(), "components");
        }
        try (BulkChange bc = new BulkChange((Saveable)this);){
            this.setComponentIds(this.parseRequest(req, json));
            if (!this.isEnforcedPeriod()) {
                this.setPeriod(json.getInt("period"));
            }
            this.setEnabled(json.getBoolean("enabled"));
            bc.commit();
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "Failed to save " + String.valueOf(this.getConfigFile()), e);
        }
        return true;
    }

    protected final List<String> parseRequest(StaplerRequest2 req, JSONObject json) {
        HashSet<String> remove = new HashSet<String>();
        for (SupportAction.Selection s : req.bindJSONToList(SupportAction.Selection.class, json.get("components"))) {
            if (s.isSelected()) continue;
            remove.add(s.getName());
        }
        return SupportAutomatedBundleConfiguration.getApplicableComponents().stream().filter(component -> !remove.contains(component.getId()) && component.isEnabled()).map(Component::getId).collect(Collectors.toList());
    }

    @NonNull
    public GlobalConfigurationCategory getCategory() {
        return GlobalConfigurationCategory.get(SupportPluginConfigurationCategory.class);
    }

    public FormValidation doCheckPeriod(@QueryParameter String value) {
        int i;
        if (value == null) {
            return FormValidation.error((String)Messages.SupportAutomatedBundleConfiguration_period_mustBeSpecified());
        }
        try {
            i = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return FormValidation.error((String)Messages.SupportAutomatedBundleConfiguration_period_isNotAnInteger(), (Object[])new Object[]{e});
        }
        if (i < 1) {
            return FormValidation.error((String)Messages.SupportAutomatedBundleConfiguration_period_lowerThanMin());
        }
        if (i > 24) {
            return FormValidation.error((String)Messages.SupportAutomatedBundleConfiguration_period_greaterThanMax());
        }
        return FormValidation.ok();
    }
}

