/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support.api;

import com.cloudbees.jenkins.support.api.BaseFileContent;
import com.cloudbees.jenkins.support.api.Content;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Logger;

public class UnfilteredFileContent
extends Content {
    protected final File file;
    private BaseFileContent baseFileContent;
    private final Logger LOGGER = Logger.getLogger(this.getClass().getName());

    public UnfilteredFileContent(String name, File file) {
        this(name, file, -1L);
    }

    public UnfilteredFileContent(String name, File file, long maxSize) {
        super(name);
        this.file = file;
        this.baseFileContent = this.createBaseFileContent(file, maxSize);
    }

    public UnfilteredFileContent(String name, String[] filterableParameters, File file) {
        this(name, filterableParameters, file, -1L);
    }

    public UnfilteredFileContent(String name, String[] filterableParameters, File file, long maxSize) {
        super(name, filterableParameters);
        this.file = file;
        this.baseFileContent = this.createBaseFileContent(file, maxSize);
    }

    @Override
    public void writeTo(OutputStream os) throws IOException {
        this.baseFileContent.writeTo(os);
    }

    @Override
    public long getTime() throws IOException {
        return this.baseFileContent.getTime();
    }

    protected InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    private BaseFileContent createBaseFileContent(File file, long maxSize) {
        return new BaseFileContent(file, this::getInputStream, maxSize, s -> s);
    }

    @Override
    public boolean shouldBeFiltered() {
        return false;
    }
}

