/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support.api;

import com.cloudbees.jenkins.support.api.BaseFileContent;
import com.cloudbees.jenkins.support.filter.ContentFilter;
import com.cloudbees.jenkins.support.filter.PrefilteredContent;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileContent
extends PrefilteredContent {
    protected BaseFileContent baseFileContent;
    protected final File file;

    public FileContent(String name, File file) {
        this(name, file, -1L);
    }

    public FileContent(String name, File file, long maxSize) {
        super(name);
        this.file = file;
        this.baseFileContent = this.createBaseFileContent(file, maxSize);
    }

    public FileContent(String name, String[] filterableParameters, File file) {
        this(name, filterableParameters, file, -1L);
    }

    public FileContent(String name, String[] filterableParameters, File file, long maxSize) {
        super(name, filterableParameters);
        this.file = file;
        this.baseFileContent = this.createBaseFileContent(file, maxSize);
    }

    @Override
    public void writeTo(OutputStream os) throws IOException {
        this.baseFileContent.writeTo(os);
    }

    @Override
    public void writeTo(OutputStream os, @NonNull ContentFilter filter) throws IOException {
        this.baseFileContent.writeTo(os, filter);
    }

    @Override
    public long getTime() {
        return this.baseFileContent.getTime();
    }

    protected InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    protected String getSimpleValueOrRedactedPassword(String value) {
        return value;
    }

    private BaseFileContent createBaseFileContent(File file, long maxSize) {
        return new BaseFileContent(file, this::getInputStream, maxSize, this::getSimpleValueOrRedactedPassword);
    }
}

