/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support.api;

import com.cloudbees.jenkins.support.filter.ContentFilter;
import com.cloudbees.jenkins.support.util.StreamUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Functions;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.apache.commons.io.IOUtils;

final class BaseFileContent {
    private final File file;
    private final InputStreamSupplier inputStreamSupplier;
    private final Function<String, String> secretsFilterFunction;
    private final long maxSize;
    private final boolean isBinary;
    private static final String ENCODING = "UTF-8";

    BaseFileContent(File file, InputStreamSupplier inputStreamSupplier, long maxSize, UnaryOperator<String> secretsFilterFunction) {
        this.file = file;
        this.inputStreamSupplier = inputStreamSupplier;
        this.secretsFilterFunction = secretsFilterFunction;
        this.maxSize = maxSize;
        this.isBinary = this.isBinary();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeTo(OutputStream os) throws IOException {
        try (InputStream is = this.inputStreamSupplier.get();){
            if (this.maxSize == -1L) {
                IOUtils.copy((InputStream)is, (OutputStream)os);
            } else {
                IOUtils.copy((InputStream)new TruncatedInputStream(is, this.maxSize), (OutputStream)os);
            }
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            OutputStreamWriter osw = new OutputStreamWriter(os, ENCODING);
            try {
                PrintWriter pw = new PrintWriter((Writer)osw, true);
                try {
                    pw.println("--- WARNING: Could not attach " + String.valueOf(this.file) + " as it cannot currently be found ---");
                    pw.println();
                    Functions.printStackTrace((Throwable)e, (PrintWriter)pw);
                }
                finally {
                    pw.flush();
                }
            }
            finally {
                osw.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeTo(OutputStream os, @NonNull ContentFilter filter) throws IOException {
        block28: {
            if (this.isBinary || filter == ContentFilter.NONE) {
                this.writeTo(os);
                return;
            }
            try (InputStream is = this.inputStreamSupplier.get();){
                if (this.maxSize == -1L) {
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(is, ENCODING));){
                        String s;
                        while ((s = reader.readLine()) != null) {
                            String filtered = ContentFilter.filter(filter, this.secretsFilterFunction.apply(s)) + "\n";
                            IOUtils.write((String)filtered, (OutputStream)os, (String)ENCODING);
                        }
                        break block28;
                    }
                }
                try (TruncatedInputStreamReader reader = new TruncatedInputStreamReader(is, this.maxSize);){
                    String s;
                    while ((s = reader.readLine()) != null) {
                        String filtered = ContentFilter.filter(filter, this.secretsFilterFunction.apply(s)) + "\n";
                        IOUtils.write((String)filtered, (OutputStream)os, (String)ENCODING);
                    }
                }
            }
            catch (FileNotFoundException | NoSuchFileException e) {
                OutputStreamWriter osw = new OutputStreamWriter(os, ENCODING);
                try {
                    PrintWriter pw = new PrintWriter((Writer)osw, true);
                    try {
                        pw.println("--- WARNING: Could not attach " + String.valueOf(this.file) + " as it cannot currently be found ---");
                        pw.println();
                        Functions.printStackTrace((Throwable)e, (PrintWriter)pw);
                    }
                    finally {
                        pw.flush();
                    }
                }
                finally {
                    osw.flush();
                }
            }
        }
    }

    long getTime() {
        return this.file.lastModified();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isBinary() {
        try (InputStream in = this.inputStreamSupplier.get();){
            long size = Files.size(this.file.toPath());
            if (size == 0L) {
                boolean bl = true;
                return bl;
            }
            byte[] b = new byte[size < 20L ? (int)size : 20];
            int read = in.read(b);
            if (read != b.length) {
                boolean bl = true;
                return bl;
            }
            boolean bl = StreamUtils.isNonWhitespaceControlCharacter(b);
            return bl;
        }
        catch (IOException e) {
            return true;
        }
    }

    @FunctionalInterface
    static interface InputStreamSupplier {
        public InputStream get() throws IOException;
    }

    private static final class TruncatedInputStream
    extends FilterInputStream {
        private long len;

        TruncatedInputStream(InputStream in, long len) {
            super(in);
            this.len = len;
        }

        @Override
        public int read() throws IOException {
            if (this.len <= 0L) {
                return -1;
            }
            --this.len;
            return super.read();
        }

        @Override
        public int read(byte[] b, int off, int l) throws IOException {
            int toRead = (int)Math.min((long)l, this.len);
            if (toRead <= 0) {
                return -1;
            }
            int r = super.read(b, off, toRead);
            if (r > 0) {
                this.len -= (long)r;
            }
            return r;
        }

        @Override
        public int available() throws IOException {
            return (int)Math.min((long)super.available(), this.len);
        }

        @Override
        public long skip(long n) throws IOException {
            long r = super.skip(Math.min(this.len, n));
            this.len -= r;
            return r;
        }
    }

    private static final class TruncatedInputStreamReader
    extends BufferedReader {
        private long len;

        TruncatedInputStreamReader(InputStream is, long len) throws IOException {
            super(new InputStreamReader(is, BaseFileContent.ENCODING));
            this.len = len;
        }

        @Override
        public String readLine() throws IOException {
            if (this.len <= 0L) {
                return null;
            }
            String line = super.readLine();
            if (line == null) {
                return null;
            }
            int length = line.getBytes(BaseFileContent.ENCODING).length;
            int toRead = (long)length <= this.len ? length : (int)this.len;
            this.len -= (long)length;
            byte[] dest = new byte[toRead];
            System.arraycopy(line.getBytes(BaseFileContent.ENCODING), 0, dest, 0, toRead);
            return new String(dest, BaseFileContent.ENCODING);
        }
    }
}

