/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support.actions;

import com.cloudbees.jenkins.support.BundleFileName;
import com.cloudbees.jenkins.support.SupportPlugin;
import com.cloudbees.jenkins.support.actions.Messages;
import com.cloudbees.jenkins.support.api.Component;
import com.cloudbees.jenkins.support.api.ComponentVisitor;
import com.cloudbees.jenkins.support.api.Container;
import com.cloudbees.jenkins.support.api.ObjectComponent;
import com.cloudbees.jenkins.support.api.ObjectComponentDescriptor;
import com.cloudbees.jenkins.support.api.SupportProvider;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.AbstractModelObject;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.Saveable;
import hudson.util.DescribableList;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jvnet.localizer.Localizable;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.interceptor.RequirePOST;

public abstract class SupportObjectAction<T extends AbstractModelObject>
implements Action {
    static final Logger LOGGER = Logger.getLogger(SupportObjectAction.class.getName());
    private List<? extends ObjectComponent<T>> components = new ArrayList<ObjectComponent<T>>();
    @NonNull
    private final T object;

    public SupportObjectAction(@NonNull T object) {
        this.object = object;
    }

    @NonNull
    public final T getObject() {
        return this.object;
    }

    public String getUrlName() {
        return "support";
    }

    public String getIconFileName() {
        return "symbol-support plugin-support-core";
    }

    protected String getBundleNameQualifier() {
        return "object";
    }

    @DataBoundSetter
    public void setComponents(List<? extends ObjectComponent<T>> components) {
        this.components = new ArrayList<ObjectComponent<T>>(components);
    }

    public Localizable getActionTitle() {
        SupportProvider supportProvider;
        SupportPlugin supportPlugin = SupportPlugin.getInstance();
        if (supportPlugin != null && (supportProvider = supportPlugin.getSupportProvider()) != null) {
            return supportProvider.getActionTitle();
        }
        return Messages._SupportObjectAction_DefaultActionTitle();
    }

    public Localizable getActionBlurb() {
        SupportProvider supportProvider;
        SupportPlugin supportPlugin = SupportPlugin.getInstance();
        if (supportPlugin != null && (supportProvider = supportPlugin.getSupportProvider()) != null) {
            return supportProvider.getActionBlurb();
        }
        return Messages._SupportObjectAction_DefaultActionBlurb();
    }

    public List<? extends ObjectComponent<T>> getComponents() {
        return this.components;
    }

    public List<ObjectComponentDescriptor<T>> getApplicableComponentsDescriptors() {
        return ObjectComponent.for_(this.object);
    }

    public Map<ObjectComponentDescriptor<T>, ObjectComponent<T>> getDefaultComponentsDescriptors() {
        return ObjectComponent.allInstances(this.object).stream().filter(oComponent -> oComponent.isSelectedByDefault(this.object)).collect(Collectors.toMap(ObjectComponent::getDescriptor, Function.identity()));
    }

    @RequirePOST
    public final void doGenerateAndDownload(StaplerRequest2 req, StaplerResponse2 rsp) throws ServletException, IOException, Descriptor.FormException {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        LOGGER.fine("Preparing response...");
        rsp.setContentType("application/zip");
        JSONObject json = req.getSubmittedForm();
        if (json == null || !json.has("components")) {
            rsp.sendError(400);
            return;
        }
        LOGGER.fine("Parsing request...");
        ArrayList<ObjectComponent<T>> components = new ArrayList<ObjectComponent<T>>(this.parseRequest(req));
        rsp.addHeader("Content-Disposition", "inline; filename=" + BundleFileName.generate(this.getBundleNameQualifier()) + ";");
        try {
            SupportPlugin.writeBundle((OutputStream)rsp.getOutputStream(), components, new ComponentVisitor(){

                public <C extends Component> void visit(Container container, C component) {
                    ((ObjectComponent)component).addContents(container, SupportObjectAction.this.object);
                }
            }, null, true);
            LOGGER.fine("Response completed");
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, e.getMessage(), e);
        }
    }

    protected final List<ObjectComponent<T>> parseRequest(StaplerRequest2 req) throws ServletException, Descriptor.FormException {
        DescribableList components = new DescribableList(Saveable.NOOP);
        try {
            JSONObject componentsSection = req.getSubmittedForm().getJSONObject("components");
            components.rebuild(req, componentsSection, this.getApplicableComponentsDescriptors());
        }
        catch (IOException e) {
            throw new Descriptor.FormException((Throwable)e, "components");
        }
        return components;
    }
}

