/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support;

import com.cloudbees.jenkins.support.BundleFileName;
import com.cloudbees.jenkins.support.Messages;
import com.cloudbees.jenkins.support.SupportContextImpl;
import com.cloudbees.jenkins.support.SupportLogHandler;
import com.cloudbees.jenkins.support.api.Component;
import com.cloudbees.jenkins.support.api.ComponentVisitor;
import com.cloudbees.jenkins.support.api.Container;
import com.cloudbees.jenkins.support.api.Content;
import com.cloudbees.jenkins.support.api.SupportProvider;
import com.cloudbees.jenkins.support.api.SupportProviderDescriptor;
import com.cloudbees.jenkins.support.api.UnfilteredStringContent;
import com.cloudbees.jenkins.support.config.SupportAutomatedBundleConfiguration;
import com.cloudbees.jenkins.support.filter.ContentFilter;
import com.cloudbees.jenkins.support.filter.ContentFilters;
import com.cloudbees.jenkins.support.filter.FilteredOutputStream;
import com.cloudbees.jenkins.support.filter.PrefilteredContent;
import com.cloudbees.jenkins.support.impl.ThreadDumps;
import com.cloudbees.jenkins.support.util.CallAsyncWrapper;
import com.cloudbees.jenkins.support.util.IgnoreCloseOutputStream;
import com.cloudbees.jenkins.support.util.OutputStreamSelector;
import com.codahale.metrics.Histogram;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.BulkChange;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.FilePath;
import hudson.Functions;
import hudson.Main;
import hudson.Plugin;
import hudson.Util;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Node;
import hudson.model.PeriodicWork;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.ChannelClosedException;
import hudson.remoting.Future;
import hudson.remoting.VirtualChannel;
import hudson.security.ACL;
import hudson.security.ACLContext;
import hudson.security.Permission;
import hudson.security.PermissionGroup;
import hudson.security.PermissionScope;
import hudson.slaves.ComputerListener;
import hudson.triggers.SafeTimerTask;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.DoubleConsumer;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import jenkins.metrics.impl.JenkinsMetricProviderImpl;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import jenkins.security.MasterToSlaveCallable;
import net.sf.json.JSONObject;
import org.apache.commons.io.output.CountingOutputStream;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.StaplerRequest2;
import org.springframework.security.core.Authentication;

public class SupportPlugin
extends Plugin {
    private static final Logger LOGGER = Logger.getLogger(SupportPlugin.class.getName());
    public static final int REMOTE_OPERATION_TIMEOUT_MS = Integer.getInteger(SupportPlugin.class.getName() + ".REMOTE_OPERATION_TIMEOUT_MS", 500);
    public static final int REMOTE_OPERATION_CACHE_TIMEOUT_SEC = Integer.getInteger(SupportPlugin.class.getName() + ".REMOTE_OPERATION_CACHE_TIMEOUT_SEC", 300);
    public static final int AUTO_BUNDLE_PERIOD_HOURS = Math.max(Math.min(24, Integer.getInteger(SupportPlugin.class.getName() + ".AUTO_BUNDLE_PERIOD_HOURS", 1)), 0);
    public static final int MAX_JENKINS_LOG_ENTRIES_PER_FILE = Integer.getInteger(SupportPlugin.class.getName() + ".MAX_JENKINS_LOG_ENTRIES_PER_FILE", 2048);
    public static final PermissionGroup SUPPORT_PERMISSIONS = new PermissionGroup(SupportPlugin.class, Messages._SupportPlugin_PermissionGroup());
    @Deprecated
    public static final Permission CREATE_BUNDLE = new Permission(SUPPORT_PERMISSIONS, "DownloadBundle", Messages._SupportPlugin_CreateBundle(), Jenkins.ADMINISTER, PermissionScope.JENKINS);
    private static final AtomicLong nextBundleWrite = new AtomicLong(Long.MIN_VALUE);
    private static final Logger logger = Logger.getLogger(SupportPlugin.class.getName());
    public static final String SUPPORT_DIRECTORY_NAME = "support";
    private final transient SupportLogHandler handler = new SupportLogHandler(256, MAX_JENKINS_LOG_ENTRIES_PER_FILE, 8);
    private transient SupportContextImpl context = null;
    private transient Logger rootLogger;
    private transient WeakHashMap<Node, List<LogRecord>> logRecords;
    private SupportProvider supportProvider;
    private Set<String> excludedComponents;
    private static final boolean logStartupPerformanceIssues = Boolean.getBoolean(SupportPlugin.class.getCanonicalName() + ".threadDumpStartup");
    private static final int secondsPerThreadDump = Integer.getInteger(SupportPlugin.class.getCanonicalName() + ".secondsPerTD", 60);

    public SupportPlugin() {
        this.handler.setLevel(SupportPlugin.getLogLevel());
        this.handler.setDirectory(SupportPlugin.getLogsDirectory(), "all");
    }

    @Initializer(after=InitMilestone.EXTENSIONS_AUGMENTED)
    public static void migrateExistingLogs() {
        File rootDirectory = SupportPlugin.getRootDirectory();
        File[] files = rootDirectory.listFiles();
        if (files != null) {
            for (File f : files) {
                if (!f.isFile() || !f.getName().endsWith(".log")) continue;
                Path p = f.toPath();
                try {
                    Files.move(p, SupportPlugin.getLogsDirectory().toPath().resolve(p.getFileName()), new CopyOption[0]);
                    LOGGER.log(Level.INFO, "Moved " + String.valueOf(p) + " to " + String.valueOf(SupportPlugin.getLogsDirectory()));
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, e, () -> "Unable to move " + String.valueOf(p) + " to " + String.valueOf(SupportPlugin.getLogsDirectory()));
                }
            }
        }
    }

    public SupportProvider getSupportProvider() {
        if (this.supportProvider == null) {
            for (Descriptor d : Jenkins.get().getDescriptorList(SupportProvider.class)) {
                if (!(d instanceof SupportProviderDescriptor)) continue;
                try {
                    this.supportProvider = ((SupportProviderDescriptor)d).newDefaultInstance();
                }
                catch (Throwable throwable) {}
            }
        }
        return this.supportProvider;
    }

    public static File getRootDirectory() {
        return new File(Jenkins.get().getRootDir(), SUPPORT_DIRECTORY_NAME);
    }

    public static File getLogsDirectory() {
        return new File(SafeTimerTask.getLogsRoot(), SUPPORT_DIRECTORY_NAME);
    }

    @Deprecated
    public static Authentication getRequesterAuthentication() {
        return Jenkins.getAuthentication2();
    }

    public void setSupportProvider(SupportProvider supportProvider) throws IOException {
        if (supportProvider != this.supportProvider) {
            this.supportProvider = supportProvider;
            this.save();
        }
    }

    public Set<String> getExcludedComponents() {
        return this.excludedComponents != null ? this.excludedComponents : Collections.emptySet();
    }

    public void setExcludedComponents(Set<String> excludedComponents) throws IOException {
        this.excludedComponents = excludedComponents;
        this.save();
    }

    public Histogram getJenkinsExecutorTotalCount() {
        return JenkinsMetricProviderImpl.instance().getJenkinsExecutorTotalCount();
    }

    public Histogram getJenkinsExecutorUsedCount() {
        return JenkinsMetricProviderImpl.instance().getJenkinsExecutorUsedCount();
    }

    public Histogram getJenkinsNodeOnlineCount() {
        return JenkinsMetricProviderImpl.instance().getJenkinsNodeOnlineCount();
    }

    public Histogram getJenkinsNodeTotalCount() {
        return JenkinsMetricProviderImpl.instance().getJenkinsNodeTotalCount();
    }

    private static Level getLogLevel() {
        return Level.parse(System.getProperty(SupportPlugin.class.getName() + ".LogLevel", "INFO"));
    }

    public static void setLogLevel(String level) {
        SupportPlugin.setLogLevel(Level.parse(Objects.toString(Util.fixEmptyAndTrim((String)level), "INFO")));
    }

    public static void setLogLevel(Level level) {
        SupportPlugin instance = SupportPlugin.getInstance();
        instance.handler.setLevel(level);
        for (Node n : Jenkins.get().getNodes()) {
            VirtualChannel channel;
            Computer c = n.toComputer();
            if (c == null || (channel = c.getChannel()) == null) continue;
            try {
                channel.callAsync((Callable)new LogUpdater(level));
            }
            catch (IOException iOException) {}
        }
    }

    public static SupportPlugin getInstance() {
        return (SupportPlugin)Jenkins.get().getPlugin(SupportPlugin.class);
    }

    public static ExtensionList<Component> getComponents() {
        ExtensionList list = ExtensionList.create((Jenkins)Jenkins.get(), NonExistentComponent.class);
        if (list.isEmpty()) {
            List applicableComponents = Jenkins.get().getExtensionList(Component.class).stream().filter(component -> component.isApplicable(Jenkins.class)).collect(Collectors.toList());
            list.addAll(applicableComponents);
        }
        return list;
    }

    @Deprecated
    public static void writeBundle(OutputStream outputStream) throws IOException {
        SupportPlugin.writeBundle(outputStream, SupportAutomatedBundleConfiguration.get().getComponents());
    }

    public static void writeBundle(OutputStream outputStream, List<? extends Component> components) throws IOException {
        SupportPlugin.writeBundle(outputStream, components, new ComponentVisitor(){

            @Override
            public <T extends Component> void visit(Container container, T component) {
                component.addContents(container);
            }
        }, null, true);
    }

    static void writeBundleForSyncComponents(OutputStream outputStream, List<? extends Component> components) throws IOException {
        SupportPlugin.writeBundle(outputStream, components, new ComponentVisitor(){

            @Override
            public <T extends Component> void visit(Container container, T component) {
                component.addContents(container);
            }
        }, null, false);
    }

    static void writeBundle(OutputStream outputStream, final List<? extends Component> components, final DoubleConsumer progressCallback, Path outputPath) throws IOException {
        SupportPlugin.writeBundle(outputStream, components, new ComponentVisitor(){
            private final int totalComponents;
            private int currentIteration;
            {
                this.totalComponents = components.size();
                this.currentIteration = 0;
            }

            @Override
            public <T extends Component> void visit(Container container, T component) {
                if (component.canBeGeneratedAsync()) {
                    component.addContents(container);
                }
                progressCallback.accept((double)this.currentIteration++ / (double)this.totalComponents);
            }
        }, outputPath, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeBundle(OutputStream outputStream, List<? extends Component> components, ComponentVisitor componentConsumer, Path outputPath, boolean addManifest) throws IOException {
        StringBuilder manifest = new StringBuilder();
        StringWriter errors = new StringWriter();
        PrintWriter errorWriter = new PrintWriter(errors);
        try (BulkChange change = new BulkChange(ContentFilter.bulkChangeTarget());
             CountingOutputStream countingOs = new CountingOutputStream(outputStream);
             ZipOutputStream binaryOut = new ZipOutputStream(new BufferedOutputStream((OutputStream)countingOs, 16384));){
            long startSize;
            boolean entryCreated;
            FilteredOutputStream textOut;
            long startTime;
            block45: {
                ContentFilter filter = SupportPlugin.getDefaultContentFilter(true);
                SupportPlugin.appendManifestHeader(manifest);
                startTime = System.currentTimeMillis();
                List<Content> contents = SupportPlugin.appendManifestContents(manifest, errorWriter, components, componentConsumer, filter);
                LOGGER.log(Level.FINE, "Took " + (System.currentTimeMillis() - startTime) + "ms to process all components");
                if (addManifest) {
                    contents.add(new UnfilteredStringContent("manifest.md", manifest.toString()));
                }
                textOut = new FilteredOutputStream(binaryOut, filter);
                OutputStreamSelector selector = new OutputStreamSelector(() -> binaryOut, () -> textOut);
                IgnoreCloseOutputStream unfilteredOut = new IgnoreCloseOutputStream(binaryOut);
                IgnoreCloseOutputStream filteredOut = new IgnoreCloseOutputStream(selector);
                entryCreated = false;
                startTime = System.currentTimeMillis();
                startSize = countingOs.getByteCount();
                for (Content content : contents) {
                    if (content == null) continue;
                    LOGGER.log(Level.FINE, "Start writing support content " + String.valueOf(content.getClass()));
                    long contentStartTime = System.currentTimeMillis();
                    long contentStartSize = countingOs.getByteCount();
                    String name = SupportPlugin.getNameFiltered(filter, content.getName(), content.getFilterableParameters());
                    try {
                        IgnoreCloseOutputStream out;
                        ZipEntry entry = new ZipEntry(name);
                        entry.setTime(content.getTime());
                        binaryOut.putNextEntry(entry);
                        entryCreated = true;
                        binaryOut.flush();
                        IgnoreCloseOutputStream ignoreCloseOutputStream = out = content.shouldBeFiltered() ? filteredOut : unfilteredOut;
                        if (content instanceof PrefilteredContent) {
                            ((PrefilteredContent)content).writeTo(out, filter);
                        } else {
                            content.writeTo(out);
                        }
                        ((OutputStream)out).flush();
                    }
                    catch (Throwable e) {
                        String msg = "Could not attach ''" + name + "'' to support bundle";
                        logger.log(e instanceof ChannelClosedException ? Level.FINE : Level.WARNING, msg, e);
                        errorWriter.println(msg);
                        errorWriter.println("-----------------------------------------------------------------------");
                        errorWriter.println();
                        Functions.printStackTrace((Throwable)e, (PrintWriter)errorWriter);
                        errorWriter.println();
                    }
                    finally {
                        textOut.reset();
                        selector.reset();
                        if (entryCreated) {
                            binaryOut.closeEntry();
                            entryCreated = false;
                        }
                        LOGGER.log(Level.FINE, "Took " + (System.currentTimeMillis() - contentStartTime) + "ms and generated " + (countingOs.getByteCount() - contentStartSize) + " bytes to write content " + name);
                    }
                }
                if (outputPath != null) {
                    try {
                        File zipFile = outputPath.resolve("support-bundle.zip").toFile();
                        if (zipFile.exists()) {
                            try (ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFile));){
                                ZipEntry entry;
                                while ((entry = zis.getNextEntry()) != null) {
                                    binaryOut.putNextEntry(entry);
                                    zis.transferTo(binaryOut);
                                }
                                break block45;
                            }
                        }
                        LOGGER.log(Level.FINE, "No sync component to process");
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.WARNING, "Error while processing sync components in async mode", e);
                    }
                }
            }
            LOGGER.log(Level.FINE, "Took " + (System.currentTimeMillis() - startTime) + "ms and generated " + (countingOs.getByteCount() - startSize) + " bytes to process all contents");
            errorWriter.close();
            String errorContent = errors.toString();
            if (errorContent != null && !errorContent.isBlank()) {
                try {
                    binaryOut.putNextEntry(new ZipEntry("manifest/errors.txt"));
                    entryCreated = true;
                    textOut.write(errorContent.getBytes(StandardCharsets.UTF_8));
                    textOut.flush();
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "Could not write manifest/errors.txt to zip archive", e);
                }
                finally {
                    if (entryCreated) {
                        binaryOut.closeEntry();
                    }
                }
            }
            binaryOut.flush();
            change.commit();
        }
        finally {
            outputStream.flush();
        }
    }

    static String getNameFiltered(ContentFilter contentFilter, String name, String[] filterableParameters) {
        String filteredName;
        if (filterableParameters != null) {
            Object[] replacedParameters = Arrays.stream(filterableParameters).map(contentFilter::filter).toArray(String[]::new);
            filteredName = MessageFormat.format(name, replacedParameters);
        } else {
            filteredName = name;
        }
        return filteredName;
    }

    @Deprecated
    @NonNull
    public static Optional<ContentFilter> getContentFilter() {
        return Optional.of(SupportPlugin.getDefaultContentFilter(true));
    }

    @Deprecated
    public static Optional<ContentFilter> getContentFilter(boolean ensureLoaded) {
        ContentFilters filters = ContentFilters.get();
        if (filters.isEnabled()) {
            return Optional.of(SupportPlugin.getDefaultContentFilter(ensureLoaded));
        }
        return Optional.empty();
    }

    @NonNull
    public static ContentFilter getDefaultContentFilter() {
        return SupportPlugin.getDefaultContentFilter(true);
    }

    @NonNull
    public static ContentFilter getDefaultContentFilter(boolean ensureLoaded) {
        ContentFilters filters = ContentFilters.get();
        if (filters.isEnabled()) {
            ContentFilter filter = ContentFilter.ALL;
            if (ensureLoaded) {
                try {
                    ContentFilter.reloadAndSaveMappings(filter);
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Failed to reload filter and save mappings", e);
                }
            }
            return filter;
        }
        return ContentFilter.NONE;
    }

    private static void appendManifestHeader(StringBuilder manifest) {
        SupportPlugin plugin = SupportPlugin.getInstance();
        SupportProvider supportProvider = plugin == null ? null : plugin.getSupportProvider();
        String bundleName = (supportProvider == null ? "Support" : supportProvider.getDisplayName()) + " Bundle Manifest";
        manifest.append(bundleName).append('\n').append("=".repeat(bundleName.length())).append("\n\n");
        SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSZ");
        f.setTimeZone(TimeZone.getTimeZone("UTC"));
        manifest.append("Generated on ").append(f.format(new Date())).append("\n\n");
    }

    private static List<Content> appendManifestContents(StringBuilder manifest, PrintWriter errors, List<? extends Component> components, ComponentVisitor componentVisitor, ContentFilter contentFilter) {
        manifest.append("Requested components:\n\n");
        ContentContainer contentsContainer = new ContentContainer(contentFilter, components);
        for (Component component : components) {
            try {
                if (components.stream().anyMatch(c -> c.supersedes(component))) continue;
                manifest.append("  * ").append(component.getDisplayName()).append("\n\n");
                LOGGER.log(Level.FINE, "Start processing " + component.getDisplayName());
                long startTime = System.currentTimeMillis();
                componentVisitor.visit(contentsContainer, component);
                LOGGER.log(Level.FINE, "Took " + (System.currentTimeMillis() - startTime) + "ms to process component " + component.getDisplayName());
                Set<String> names = contentsContainer.getLatestNames();
                for (String name : names) {
                    manifest.append("      - `").append(name).append("`\n\n");
                }
            }
            catch (Throwable e) {
                String displayName;
                try {
                    displayName = component.getDisplayName();
                }
                catch (Throwable ignored) {
                    displayName = component.getClass().getName();
                }
                String msg = "Could not get content from " + displayName + " for support bundle";
                logger.log(Level.WARNING, msg, e);
                errors.println(msg);
                errors.println("-----------------------------------------------------------------------");
                errors.println();
                Functions.printStackTrace((Throwable)e, (PrintWriter)errors);
                errors.println();
            }
        }
        return contentsContainer.getContents();
    }

    public List<LogRecord> getAllLogRecords() {
        return this.handler.getRecent();
    }

    @Initializer(after=InitMilestone.EXTENSIONS_AUGMENTED, before=InitMilestone.JOB_LOADED)
    public static void loadConfig() throws IOException {
        SupportPlugin instance = SupportPlugin.getInstance();
        if (instance != null) {
            instance.load();
        }
    }

    @Deprecated
    @Restricted(value={NoExternalUse.class})
    public static void completedMilestones() throws IOException {
    }

    @Initializer(after=InitMilestone.STARTED)
    public static void threadDumpStartup() throws Exception {
        if (!logStartupPerformanceIssues) {
            return;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        final File f = new File(SupportPlugin.getRootDirectory(), "/startup-threadDump" + dateFormat.format(new Date()) + ".txt");
        if (!f.exists()) {
            try {
                f.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        Thread t = new Thread("Support core plugin startup diagnostics"){

            @Override
            public void run() {
                block9: while (true) {
                    try {
                        while (true) {
                            Jenkins jenkins;
                            if ((jenkins = Jenkins.getInstanceOrNull()) == null || jenkins.getInitLevel() != InitMilestone.COMPLETED) {
                                continue;
                            }
                            try {
                                PrintStream ps = new PrintStream((OutputStream)new FileOutputStream(f, true), false, "UTF-8");
                                try {
                                    ps.println("=== Thread dump at " + String.valueOf(new Date()) + " ===");
                                    ThreadDumps.threadDump(ps);
                                    ps.flush();
                                    TimeUnit.SECONDS.sleep(secondsPerThreadDump);
                                    continue block9;
                                }
                                finally {
                                    ps.close();
                                    continue block9;
                                }
                            }
                            catch (FileNotFoundException | UnsupportedEncodingException e) {
                                e.printStackTrace();
                                continue;
                            }
                            break;
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        Thread.currentThread().interrupt();
                        return;
                    }
                }
            }
        };
        t.start();
    }

    public synchronized void start() throws Exception {
        super.start();
        this.rootLogger = Logger.getLogger("");
        this.rootLogger.addHandler(this.handler);
        this.context = new SupportContextImpl();
    }

    @Deprecated
    @NonNull
    public synchronized SupportContextImpl getContext() {
        return this.context;
    }

    public synchronized void stop() throws Exception {
        if (this.rootLogger != null) {
            this.rootLogger.removeHandler(this.handler);
            this.rootLogger = null;
            this.handler.close();
        }
        this.context.shutdown();
        super.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LogRecord> getAllLogRecords(Node node) throws IOException, InterruptedException {
        VirtualChannel channel;
        if (node != null && (channel = node.getChannel()) != null) {
            Future future = CallAsyncWrapper.callAsync(channel, new LogFetcher());
            try {
                return (List)future.get((long)REMOTE_OPERATION_TIMEOUT_MS, TimeUnit.MILLISECONDS);
            }
            catch (ExecutionException e) {
                LogRecord lr = new LogRecord(Level.WARNING, "Could not retrieve remote log records");
                lr.setThrown(e);
                return Collections.singletonList(lr);
            }
            catch (TimeoutException e) {
                Computer.threadPoolForRemoting.submit(() -> {
                    List<LogRecord> records;
                    try {
                        records = (List<LogRecord>)future.get((long)REMOTE_OPERATION_CACHE_TIMEOUT_SEC, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException e1) {
                        LogRecord lr = new LogRecord(Level.WARNING, "Could not retrieve remote log records");
                        lr.setThrown(e1);
                        records = Collections.singletonList(lr);
                    }
                    catch (ExecutionException e1) {
                        LogRecord lr = new LogRecord(Level.WARNING, "Could not retrieve remote log records");
                        lr.setThrown(e1);
                        records = Collections.singletonList(lr);
                    }
                    catch (TimeoutException e1) {
                        LogRecord lr = new LogRecord(Level.WARNING, "Could not retrieve remote log records");
                        lr.setThrown(e1);
                        records = Collections.singletonList(lr);
                        future.cancel(true);
                    }
                    SupportPlugin supportPlugin = this;
                    synchronized (supportPlugin) {
                        if (this.logRecords == null) {
                            this.logRecords = new WeakHashMap();
                        }
                        this.logRecords.put(node, records);
                    }
                });
                SupportPlugin supportPlugin = this;
                synchronized (supportPlugin) {
                    if (this.logRecords != null) {
                        List<LogRecord> result = this.logRecords.get(node);
                        if (result != null) {
                            result = new ArrayList<LogRecord>(result);
                            LogRecord lr = new LogRecord(Level.WARNING, "Using cached remote log records");
                            lr.setThrown(e);
                            result.add(lr);
                            return result;
                        }
                    } else {
                        LogRecord lr = new LogRecord(Level.WARNING, "No previous cached remote log records");
                        lr.setThrown(e);
                        return Collections.singletonList(lr);
                    }
                }
            }
        }
        return Collections.emptyList();
    }

    @Deprecated
    @NonNull
    public static String getBundleFileName() {
        return BundleFileName.generate();
    }

    public static class LogUpdater
    extends MasterToSlaveCallable<Void, RuntimeException> {
        private static final long serialVersionUID = 1L;
        private final Level level;

        public LogUpdater(Level level) {
            this.level = level;
        }

        public Void call() throws RuntimeException {
            LogHolder.AGENT_LOG_HANDLER.setLevel(this.level);
            return null;
        }
    }

    private static abstract class NonExistentComponent
    extends Component {
        private NonExistentComponent() {
        }
    }

    private static class ContentContainer
    extends Container {
        private final List<Content> contents = new ArrayList<Content>();
        private final Set<String> names = new HashSet<String>();
        private final ContentFilter contentFilter;
        private final List<? extends Component> components;

        ContentContainer(ContentFilter contentFilter, List<? extends Component> components) {
            this.contentFilter = contentFilter;
            this.components = components;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(Content content) {
            if (content != null) {
                String name = SupportPlugin.getNameFiltered(this.contentFilter, content.getName(), content.getFilterableParameters());
                ContentContainer contentContainer = this;
                synchronized (contentContainer) {
                    this.contents.add(content);
                    this.names.add(name);
                }
            }
        }

        @Override
        public List<? extends Component> getComponents() {
            return this.components;
        }

        synchronized Set<String> getLatestNames() {
            TreeSet<String> copy = new TreeSet<String>(this.names);
            this.names.clear();
            return copy;
        }

        synchronized List<Content> getContents() {
            return new ArrayList<Content>(this.contents);
        }
    }

    public static class LogFetcher
    extends MasterToSlaveCallable<List<LogRecord>, RuntimeException> {
        private static final long serialVersionUID = 1L;

        public List<LogRecord> call() throws RuntimeException {
            return new ArrayList<LogRecord>(LogHolder.AGENT_LOG_HANDLER.getRecent());
        }
    }

    @Extension
    public static class GlobalConfigurationImpl
    extends GlobalConfiguration {
        public boolean isSelectable() {
            return Jenkins.get().getDescriptorList(SupportProvider.class).size() > 1;
        }

        public SupportProvider getSupportProvider() {
            return SupportPlugin.getInstance().getSupportProvider();
        }

        public boolean configure(StaplerRequest2 req, JSONObject json) throws Descriptor.FormException {
            if (json.has("supportProvider")) {
                try {
                    SupportPlugin.getInstance().setSupportProvider((SupportProvider)((Object)req.bindJSON(SupportProvider.class, json.getJSONObject("supportProvider"))));
                }
                catch (IOException e) {
                    throw new Descriptor.FormException((Throwable)e, "supportProvider");
                }
            }
            return true;
        }
    }

    @Extension
    public static class PeriodicWorkImpl
    extends PeriodicWork {
        private Thread thread;

        public long getRecurrencePeriod() {
            return TimeUnit.SECONDS.toMillis(15L);
        }

        public long getInitialDelay() {
            return TimeUnit.MINUTES.toMillis(3L);
        }

        protected synchronized void doRun() throws Exception {
            if (Main.isUnitTest) {
                return;
            }
            SupportPlugin plugin = SupportPlugin.getInstance();
            if (plugin == null) {
                return;
            }
            SupportAutomatedBundleConfiguration automatedBundleConfig = SupportAutomatedBundleConfiguration.get();
            if (nextBundleWrite.get() < System.currentTimeMillis() && automatedBundleConfig.isEnabled()) {
                if (this.thread != null && this.thread.isAlive()) {
                    LOGGER.log(Level.INFO, "Periodic bundle generating thread is still running. Execution aborted.");
                    return;
                }
                try {
                    this.thread = new Thread(() -> {
                        nextBundleWrite.set(System.currentTimeMillis() + TimeUnit.HOURS.toMillis(automatedBundleConfig.getPeriod()));
                        this.thread.setName(String.format("%s periodic bundle generator: since %s", SupportPlugin.class.getSimpleName(), new Date()));
                        try (ACLContext ignored = ACL.as2((Authentication)ACL.SYSTEM2);){
                            File bundleDir = SupportPlugin.getRootDirectory();
                            if (!bundleDir.exists() && !bundleDir.mkdirs()) {
                                return;
                            }
                            File file = new File(bundleDir, BundleFileName.generate());
                            this.thread.setName(String.format("%s periodic bundle generator: writing %s since %s", SupportPlugin.class.getSimpleName(), file.getName(), new Date()));
                            try (FileOutputStream fos = new FileOutputStream(file);){
                                SupportPlugin.writeBundle(fos, automatedBundleConfig.getComponents());
                            }
                            finally {
                                this.cleanupOldBundles(bundleDir, file);
                            }
                        }
                        catch (Throwable t) {
                            LOGGER.log(Level.WARNING, "Could not save support bundle", t);
                        }
                    }, SupportPlugin.class.getSimpleName() + " periodic bundle generator");
                    this.thread.start();
                }
                catch (Throwable t) {
                    LOGGER.log(Level.SEVERE, "Periodic bundle generating thread failed with error", t);
                }
            }
        }

        @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE", "IS2_INCONSISTENT_SYNC"}, justification="RV_RETURN_VALUE_IGNORED_BAD_PRACTICE=Best effort, IS2_INCONSISTENT_SYNC=only called from an already synchronized method")
        private void cleanupOldBundles(File bundleDir, File justGenerated) {
            this.thread.setName(String.format("%s periodic bundle generator: tidying old bundles since %s", SupportPlugin.class.getSimpleName(), new Date()));
            File[] files = bundleDir.listFiles((dir, name) -> name.endsWith(".zip"));
            if (files == null) {
                LOGGER.log(Level.WARNING, "Something is wrong: {0} does not exist or there was an IO issue.", bundleDir.getAbsolutePath());
                return;
            }
            long pivot = System.currentTimeMillis();
            long l = 1L;
            while (l * 2L > 0L) {
                boolean seen = false;
                for (File f : files) {
                    long age;
                    if (!f.isFile() || f == justGenerated || l > (age = pivot - f.lastModified()) || age >= l * 2L) continue;
                    if (seen) {
                        f.delete();
                        LOGGER.log(Level.INFO, "Deleted old bundle {0}", f.getName());
                        continue;
                    }
                    seen = true;
                }
                l *= 2L;
            }
        }
    }

    @Extension
    public static class ComputerListenerImpl
    extends ComputerListener {
        public void onOnline(Computer c, TaskListener listener) throws IOException, InterruptedException {
            Node node = c.getNode();
            if (node == null || node instanceof Jenkins) {
                return;
            }
            try {
                FilePath rootPath;
                VirtualChannel channel = c.getChannel();
                if (channel != null && (rootPath = node.getRootPath()) != null) {
                    CallAsyncWrapper.callAsync(channel, new LogInitializer(rootPath, SupportPlugin.getLogLevel()));
                }
            }
            catch (IOException e) {
                Logger.getLogger(SupportPlugin.class.getName()).log(Level.WARNING, "Could not install root log handler on node: " + c.getName(), e);
            }
            catch (RuntimeException e) {
                Logger.getLogger(SupportPlugin.class.getName()).log(Level.WARNING, "Could not install root log handler on node: " + c.getName(), e);
            }
        }
    }

    private static class LogInitializer
    extends MasterToSlaveCallable<Void, RuntimeException> {
        private static final long serialVersionUID = 1L;
        private static final Logger ROOT_LOGGER = Logger.getLogger("");
        private final FilePath rootPath;
        private final Level level;

        public LogInitializer(FilePath rootPath, Level level) {
            this.rootPath = rootPath;
            this.level = level;
        }

        public Void call() {
            LogInitializer.closeAll();
            Runtime.getRuntime().addShutdownHook(new Thread(LogInitializer::closeAll, "close log handlers"));
            LogHolder.AGENT_LOG_HANDLER.setLevel(this.level);
            LogHolder.AGENT_LOG_HANDLER.setDirectory(new File(this.rootPath.getRemote(), SupportPlugin.SUPPORT_DIRECTORY_NAME), "all");
            ROOT_LOGGER.addHandler(LogHolder.AGENT_LOG_HANDLER);
            return null;
        }

        private static void closeAll() {
            for (Handler h : ROOT_LOGGER.getHandlers()) {
                if (!h.getClass().getName().equals(LogHolder.AGENT_LOG_HANDLER.getClass().getName())) continue;
                ROOT_LOGGER.removeHandler(h);
                try {
                    h.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    public static class LogHolder {
        private static final SupportLogHandler AGENT_LOG_HANDLER = new SupportLogHandler(256, 2048, 8);
    }
}

