/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class SupportMetricsFilter
implements Filter {
    private final ConcurrentMap<Integer, Meter> metersByStatusCode;
    private final Meter otherMeter;
    private final Counter activeRequests;
    private final Timer requestTimer;

    public SupportMetricsFilter(MetricRegistry registry, Map<Integer, String> meterNamesByStatusCode, String otherMetricName) {
        this.metersByStatusCode = new ConcurrentHashMap<Integer, Meter>(meterNamesByStatusCode.size());
        for (Map.Entry<Integer, String> entry : meterNamesByStatusCode.entrySet()) {
            this.metersByStatusCode.put(entry.getKey(), registry.meter(MetricRegistry.name(HttpServlet.class, (String[])new String[]{entry.getValue(), "responses"})));
        }
        this.otherMeter = registry.meter(MetricRegistry.name(HttpServlet.class, (String[])new String[]{otherMetricName, "responses"}));
        this.activeRequests = registry.counter(MetricRegistry.name(HttpServlet.class, (String[])new String[]{"activeRequests"}));
        this.requestTimer = registry.timer(MetricRegistry.name(HttpServlet.class, (String[])new String[]{"requests"}));
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            StatusExposingServletResponse wrappedResponse = new StatusExposingServletResponse((HttpServletResponse)response);
            this.activeRequests.inc();
            Timer.Context context = this.requestTimer.time();
            try {
                chain.doFilter(request, (ServletResponse)wrappedResponse);
            }
            finally {
                context.stop();
                this.activeRequests.dec();
                this.markMeterForStatusCode(wrappedResponse.getStatus());
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    private void markMeterForStatusCode(int status) {
        Meter metric = (Meter)this.metersByStatusCode.get(status);
        if (metric != null) {
            metric.mark();
        } else {
            this.otherMeter.mark();
        }
    }

    private static class StatusExposingServletResponse
    extends HttpServletResponseWrapper {
        private int httpStatus;

        public StatusExposingServletResponse(HttpServletResponse response) {
            super(response);
        }

        public void sendError(int sc) throws IOException {
            this.httpStatus = sc;
            super.sendError(sc);
        }

        public void sendError(int sc, String msg) throws IOException {
            this.httpStatus = sc;
            super.sendError(sc, msg);
        }

        public void setStatus(int sc) {
            this.httpStatus = sc;
            super.setStatus(sc);
        }

        public int getStatus() {
            return this.httpStatus;
        }
    }
}

