/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support;

import com.cloudbees.jenkins.support.SupportPlugin;
import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class BundleNameInstanceTypeProvider
implements ExtensionPoint {
    @VisibleForTesting
    static final String SUPPORT_BUNDLE_NAMING_INSTANCE_SPEC_PROPERTY = SupportPlugin.class.getName() + ".instanceType";
    private static final Logger LOGGER = Logger.getLogger(BundleNameInstanceTypeProvider.class.getName());

    @NonNull
    static BundleNameInstanceTypeProvider getInstance() {
        ExtensionList all = ExtensionList.lookup(BundleNameInstanceTypeProvider.class);
        int extensionCount = all.size();
        if (extensionCount > 2 && LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.log(Level.WARNING, "{0} implementations found for support bundle prefix naming strategy. Can be only 1 (default one) or 2 (default one, plus alternative). Choosing the first found among the following:", extensionCount);
            for (BundleNameInstanceTypeProvider nameProvider : all) {
                LOGGER.log(Level.WARNING, "Class {0} found", nameProvider.getClass().getName());
            }
        }
        BundleNameInstanceTypeProvider chosen = (BundleNameInstanceTypeProvider)all.get(0);
        if (extensionCount > 1) {
            LOGGER.log(Level.FINE, "Using {0} as BundleNameInstanceTypeProvider implementation", chosen.getClass().getName());
        }
        return chosen;
    }

    @NonNull
    public abstract String getInstanceType();

    @Extension(ordinal=-2.147483648E9)
    public static final class DEFAULT_STRATEGY
    extends BundleNameInstanceTypeProvider {
        @Override
        @NonNull
        public String getInstanceType() {
            return System.getProperty(SUPPORT_BUNDLE_NAMING_INSTANCE_SPEC_PROPERTY, "");
        }
    }
}

