/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support;

import com.cloudbees.jenkins.support.SupportPlugin;
import com.cloudbees.jenkins.support.util.CallAsyncWrapper;
import hudson.model.Computer;
import hudson.model.Node;
import hudson.remoting.Callable;
import hudson.remoting.VirtualChannel;
import java.io.IOException;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import jenkins.model.Jenkins;

public class AsyncResultCache<T>
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(AsyncResultCache.class.getName());
    private final WeakHashMap<Node, T> cache;
    private final Future<T> future;
    private final Node node;
    private final String name;

    public static <V, T extends Throwable> V get(Node node, WeakHashMap<Node, V> cache, Callable<V, T> operation, String name, V defaultIfNull) throws IOException {
        V result = AsyncResultCache.get(node, cache, operation, name);
        return result == null ? defaultIfNull : result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <V, T extends Throwable> V get(Node node, WeakHashMap<Node, V> cache, Callable<V, T> operation, String name) throws IOException {
        Future<Object> future;
        if (node == null) {
            LOGGER.fine("no node");
            return null;
        }
        if (node instanceof Jenkins) {
            future = Computer.threadPoolForRemoting.submit(() -> {
                try {
                    return operation.call();
                }
                catch (Throwable e) {
                    throw new IOException(e);
                }
            });
        } else {
            VirtualChannel channel = node.getChannel();
            if (channel == null) {
                LOGGER.fine("no channel for " + AsyncResultCache.getNodeName(node));
                WeakHashMap<Node, Object> weakHashMap = cache;
                synchronized (weakHashMap) {
                    return cache.get(node);
                }
            }
            future = CallAsyncWrapper.callAsync(channel, operation);
        }
        try {
            Object result = future.get(SupportPlugin.REMOTE_OPERATION_TIMEOUT_MS, TimeUnit.MILLISECONDS);
            WeakHashMap<Node, Object> weakHashMap = cache;
            synchronized (weakHashMap) {
                cache.put(node, result);
            }
            LOGGER.finer(() -> String.valueOf(operation) + " on " + AsyncResultCache.getNodeName(node) + " succeeded");
            return (V)result;
        }
        catch (InterruptedException | ExecutionException e) {
            LogRecord lr = new LogRecord(Level.FINE, "Could not retrieve {0} from {1}");
            lr.setParameters(new Object[]{name, AsyncResultCache.getNodeName(node)});
            lr.setThrown(e);
            LOGGER.log(lr);
            WeakHashMap<Node, Object> weakHashMap = cache;
            synchronized (weakHashMap) {
                return cache.get(node);
            }
        }
        catch (TimeoutException e) {
            LogRecord lr = new LogRecord(Level.FINER, "Could not retrieve {0} from {1}");
            lr.setParameters(new Object[]{name, AsyncResultCache.getNodeName(node)});
            lr.setThrown(e);
            LOGGER.log(lr);
            Computer.threadPoolForRemoting.submit(new AsyncResultCache<Object>(node, cache, future, name));
            WeakHashMap<Node, Object> weakHashMap = cache;
            synchronized (weakHashMap) {
                return cache.get(node);
            }
        }
    }

    private static String getNodeName(Node node) {
        return node instanceof Jenkins ? "master" : node.getNodeName();
    }

    public AsyncResultCache(Node node, WeakHashMap<Node, T> cache, Future<T> future, String name) {
        this.node = node;
        this.cache = cache;
        this.future = future;
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            T result = this.future.get(SupportPlugin.REMOTE_OPERATION_CACHE_TIMEOUT_SEC, TimeUnit.SECONDS);
            WeakHashMap<Node, T> weakHashMap = this.cache;
            synchronized (weakHashMap) {
                this.cache.put(this.node, result);
            }
        }
        catch (InterruptedException | ExecutionException e1) {
            LogRecord lr = new LogRecord(Level.FINE, "Could not retrieve {0} from {1} for caching");
            lr.setParameters(new Object[]{this.name, AsyncResultCache.getNodeName(this.node)});
            lr.setThrown(e1);
            LOGGER.log(lr);
        }
        catch (TimeoutException e1) {
            LogRecord lr = new LogRecord(Level.INFO, "Could not retrieve {0} from {1} for caching");
            lr.setParameters(new Object[]{this.name, AsyncResultCache.getNodeName(this.node)});
            lr.setThrown(e1);
            LOGGER.log(lr);
            this.future.cancel(true);
        }
    }
}

