/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support.util;

import com.cloudbees.jenkins.support.util.StreamUtils;
import com.cloudbees.jenkins.support.util.WrapperOutputStream;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.function.Supplier;
import net.jcip.annotations.GuardedBy;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class OutputStreamSelector
extends OutputStream
implements WrapperOutputStream {
    private final Supplier<OutputStream> binaryOutputStreamProvider;
    private final Supplier<OutputStream> textOutputStreamProvider;
    @GuardedBy(value="this")
    private ByteBuffer head;
    @GuardedBy(value="this")
    private OutputStream out;
    @GuardedBy(value="this")
    private boolean closed;

    public OutputStreamSelector(@NonNull Supplier<OutputStream> binaryOutputStreamProvider, @NonNull Supplier<OutputStream> textOutputStreamProvider) {
        this.binaryOutputStreamProvider = binaryOutputStreamProvider;
        this.textOutputStreamProvider = textOutputStreamProvider;
    }

    private void ensureOpen() {
        if (this.closed) {
            throw new IllegalStateException("Stream is closed");
        }
    }

    @Override
    public synchronized void write(int b) throws IOException {
        this.ensureOpen();
        this.write(new byte[]{(byte)b});
    }

    @Override
    public synchronized void write(@NonNull byte[] b, int off, int len) throws IOException {
        this.ensureOpen();
        if (len < 0) {
            throw new IllegalArgumentException("Length cannot be negative. Got: " + len);
        }
        if (len == 0) {
            return;
        }
        if (this.out == null) {
            this.probeContents(b, off, len);
        } else {
            this.out.write(b, off, len);
        }
    }

    private void probeContents(byte[] b, int off, int len) throws IOException {
        int toCopy;
        if (this.head == null) {
            this.head = ByteBuffer.allocate(20);
        }
        if ((toCopy = Math.min(this.head.remaining(), len)) == 0) {
            throw new IllegalStateException("No more room to buffer header, should have chosen stream by now");
        }
        this.head.put(b, off, toCopy);
        if (this.head.hasRemaining()) {
            return;
        }
        this.chooseStream();
        if (toCopy < len) {
            this.write(b, off + toCopy, len - toCopy);
        }
    }

    private void chooseStream() throws IOException {
        if (this.head == null || this.head.position() == 0) {
            this.out = Objects.requireNonNull(this.textOutputStreamProvider.get(), "No OutputStream returned by text supplier");
        } else {
            this.head.flip().mark();
            boolean hasControlCharacter = StreamUtils.isNonWhitespaceControlCharacter(this.head);
            this.head.reset();
            this.out = Objects.requireNonNull((hasControlCharacter ? this.binaryOutputStreamProvider : this.textOutputStreamProvider).get(), String.format("No OutputStream returned by %s supplier", hasControlCharacter ? "binary" : "text"));
            byte[] b = new byte[this.head.remaining()];
            this.head.get(b);
            this.write(b);
        }
        this.head = null;
    }

    @Override
    public synchronized void flush() throws IOException {
        this.ensureOpen();
        if (this.out == null) {
            this.chooseStream();
        }
        this.out.flush();
    }

    public synchronized void reset() {
        this.ensureOpen();
        this.head = null;
        this.out = null;
    }

    @Override
    public synchronized void close() throws IOException {
        this.ensureOpen();
        try {
            if (this.out == null) {
                this.chooseStream();
            }
            this.out.close();
        }
        finally {
            this.closed = true;
        }
    }

    @Override
    @NonNull
    public synchronized OutputStream unwrap() throws IOException {
        this.ensureOpen();
        this.chooseStream();
        return this.out;
    }
}

