/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support.startup;

import com.cloudbees.jenkins.support.SupportPlugin;
import com.cloudbees.jenkins.support.impl.ThreadDumps;
import com.cloudbees.jenkins.support.timer.FileListCap;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.XmlFile;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.AsyncPeriodicWork;
import hudson.model.Saveable;
import hudson.model.TaskListener;
import hudson.model.listeners.SaveableListener;
import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.util.SystemProperties;

@Extension
public final class StartupReport
extends AsyncPeriodicWork {
    private static final Logger LOGGER = Logger.getLogger(StartupReport.class.getName());
    private static final int THREAD_DUMPS_TO_RETAIN = SystemProperties.getInteger((String)(StartupReport.class.getName() + ".THREAD_DUMPS_TO_RETAIN"), (Integer)40);
    private static final int TOTAL_ITERATIONS = SystemProperties.getInteger((String)(StartupReport.class.getName() + ".TOTAL_ITERATIONS"), (Integer)1);
    private static final int INITIAL_DELAY_SECONDS = SystemProperties.getInteger((String)(StartupReport.class.getName() + ".INITIAL_DELAY_SECONDS"), (Integer)300);
    private static final int RECURRENCE_PERIOD_SECONDS = SystemProperties.getInteger((String)(StartupReport.class.getName() + ".RECURRENCE_PERIOD_SECONDS"), (Integer)30);
    private static final int DELAY_BETWEEN_THREAD_DUMPS_MS = SystemProperties.getInteger((String)(StartupReport.class.getName() + ".DELAY_BETWEEN_THREAD_DUMPS_MS"), (Integer)1000);
    private final FileListCap logs = new FileListCap(new File(SupportPlugin.getRootDirectory(), "startup-threaddumps"), THREAD_DUMPS_TO_RETAIN);
    private Map<InitMilestone, Instant> timesPerMilestone = new ConcurrentHashMap<InitMilestone, Instant>();

    public StartupReport() {
        super("Startup report");
    }

    @NonNull
    public static StartupReport get() {
        return (StartupReport)((Object)ExtensionList.lookupSingleton(StartupReport.class));
    }

    public long getRecurrencePeriod() {
        return TimeUnit.SECONDS.toMillis(RECURRENCE_PERIOD_SECONDS);
    }

    public long getInitialDelay() {
        return TimeUnit.SECONDS.toMillis(INITIAL_DELAY_SECONDS);
    }

    public Map<InitMilestone, Instant> getTimesPerMilestone() {
        return Map.copyOf(this.timesPerMilestone);
    }

    @Initializer(after=InitMilestone.PLUGINS_STARTED)
    public void onPluginsStarted() {
        this.onMilestone(InitMilestone.PLUGINS_STARTED);
    }

    @Initializer(after=InitMilestone.EXTENSIONS_AUGMENTED)
    public void onExtensionsAugmented() {
        this.onMilestone(InitMilestone.EXTENSIONS_AUGMENTED);
    }

    @Initializer(after=InitMilestone.SYSTEM_CONFIG_LOADED)
    public void onSystemConfigLoaded() {
        this.onMilestone(InitMilestone.SYSTEM_CONFIG_LOADED);
    }

    @Initializer(after=InitMilestone.SYSTEM_CONFIG_ADAPTED)
    public void onSystemConfigAdapted() {
        this.onMilestone(InitMilestone.SYSTEM_CONFIG_ADAPTED);
    }

    @Initializer(after=InitMilestone.JOB_LOADED)
    public void onJobLoaded() {
        this.onMilestone(InitMilestone.JOB_LOADED);
    }

    @Initializer(after=InitMilestone.JOB_CONFIG_ADAPTED)
    public void onJobConfigAdapted() {
        this.onMilestone(InitMilestone.JOB_CONFIG_ADAPTED);
    }

    private void onMilestone(InitMilestone milestone) {
        this.timesPerMilestone.put(milestone, Instant.now());
    }

    protected void execute(TaskListener listener) throws IOException, InterruptedException {
        if (Jenkins.get().getInitLevel() == InitMilestone.COMPLETED) {
            return;
        }
        LOGGER.fine("Collecting thread dumps for startup report");
        ThreadDumps.collectMultiple(this.logs, System.currentTimeMillis(), DELAY_BETWEEN_THREAD_DUMPS_MS, TOTAL_ITERATIONS);
    }

    public FileListCap getLogs() {
        return this.logs;
    }

    @Extension
    public static class InitialJenkinsSave
    extends SaveableListener {
        private volatile boolean disabled;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onChange(Saveable o, XmlFile file) {
            if (this.disabled) {
                return;
            }
            InitialJenkinsSave initialJenkinsSave = this;
            synchronized (initialJenkinsSave) {
                if (this.disabled) {
                    return;
                }
                if (o instanceof Jenkins && Jenkins.get().getInitLevel() == InitMilestone.COMPLETED) {
                    LOGGER.fine("Recording the initial Jenkins save");
                    StartupReport.get().timesPerMilestone.put(InitMilestone.COMPLETED, Instant.now());
                    this.disabled = true;
                }
            }
        }
    }
}

